/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.filter.sampling.infiles;

import ai.libs.jaicore.basic.TempFileHandler;
import ai.libs.jaicore.ml.core.filter.sampling.SampleElementAddedEvent;
import ai.libs.jaicore.ml.core.filter.sampling.infiles.AFileSamplingAlgorithm;
import ai.libs.jaicore.ml.core.filter.sampling.infiles.ArffUtilities;
import ai.libs.jaicore.ml.core.filter.sampling.infiles.DatasetFileSorter;
import ai.libs.jaicore.timing.TimedComputation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.api4.java.algorithm.IAlgorithm;
import org.api4.java.algorithm.events.IAlgorithmEvent;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;

public class SystematicFileSampling
extends AFileSamplingAlgorithm {
    private Random random;
    private int index;
    private int addedDatapoints;
    private TempFileHandler tempFileHandler;
    private Comparator<String> datapointComparator;
    private BufferedReader sortedDatasetFileReader;
    private List<Integer> indicesForSelection;
    private DatasetFileSorter sorter;

    public SystematicFileSampling(Random random, File input) {
        this(random, null, input);
    }

    public SystematicFileSampling(Random random, Comparator<String> datapointComparator, File input) {
        super(input);
        this.random = random;
        this.datapointComparator = datapointComparator;
        this.tempFileHandler = new TempFileHandler();
    }

    public IAlgorithmEvent nextWithException() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmException, AlgorithmTimeoutedException {
        switch (this.getState()) {
            case CREATED: {
                File sortedDatasetFile = null;
                try {
                    this.sorter = new DatasetFileSorter((File)this.getInput(), this.tempFileHandler);
                    if (this.datapointComparator != null) {
                        this.sorter.setComparator(this.datapointComparator);
                    }
                    this.setDeadline();
                    long remainingMS = this.getRemainingTimeToDeadline().milliseconds() - (long)this.getTimeoutPrecautionOffset();
                    sortedDatasetFile = (File)TimedComputation.compute(() -> this.sorter.sort(this.tempFileHandler.getTempFileDirPath() + File.separator + UUID.randomUUID().toString()), (long)remainingMS, (String)"No time left");
                    sortedDatasetFile.deleteOnExit();
                    this.sortedDatasetFileReader = new BufferedReader(new FileReader(sortedDatasetFile));
                    ArffUtilities.skipWithReaderToDatapoints(this.sortedDatasetFileReader);
                }
                catch (IOException | ExecutionException e) {
                    if (e.getCause() instanceof AlgorithmExecutionCanceledException) {
                        throw (AlgorithmExecutionCanceledException)e.getCause();
                    }
                    throw new AlgorithmException("Was not able to create a sorted dataset file.", (Throwable)e);
                }
                try {
                    this.addedDatapoints = 0;
                    this.index = 0;
                    int datapointAmount = ArffUtilities.countDatasetEntries(sortedDatasetFile, true);
                    this.indicesForSelection = new LinkedList<Integer>();
                    int k = datapointAmount / this.sampleSize;
                    int startIndex = this.random.nextInt(datapointAmount);
                    int i = 0;
                    while (this.indicesForSelection.size() < this.sampleSize) {
                        if (i % 100 == 0) {
                            this.checkAndConductTermination();
                        }
                        int e = (startIndex + k * i++) % datapointAmount;
                        this.indicesForSelection.add(e);
                    }
                    this.indicesForSelection.sort(Integer::compare);
                    return this.activate();
                }
                catch (IOException e) {
                    throw new AlgorithmException("Was not able to count the datapoints.", (Throwable)e);
                }
            }
            case ACTIVE: {
                if (this.addedDatapoints < this.sampleSize) {
                    try {
                        if (this.addedDatapoints % 100 == 0) {
                            this.checkAndConductTermination();
                        }
                        int e = this.indicesForSelection.get(this.addedDatapoints);
                        String datapoint = this.sortedDatasetFileReader.readLine();
                        ++this.index;
                        while (this.index < e) {
                            if (this.index % 100 == 0) {
                                this.checkAndConductTermination();
                            }
                            datapoint = this.sortedDatasetFileReader.readLine();
                            ++this.index;
                        }
                        assert (datapoint != null);
                        this.outputFileWriter.write(datapoint + "\n");
                        ++this.addedDatapoints;
                        return new SampleElementAddedEvent((IAlgorithm<?, ?>)this);
                    }
                    catch (IOException e) {
                        throw new AlgorithmException("Was not able to read from sorted dataset file.", (Throwable)e);
                    }
                }
                this.cleanUp();
                return this.terminate();
            }
            case INACTIVE: {
                this.cleanUp();
                if (this.addedDatapoints < this.sampleSize) {
                    throw new AlgorithmException("Expected sample size was not reached before termination");
                }
                return this.terminate();
            }
        }
        this.cleanUp();
        throw new IllegalStateException("Unknown algorithm state " + this.getState());
    }

    public void cancel() {
        super.cancel();
        this.sorter.cancel();
    }

    @Override
    protected void cleanUp() {
        this.tempFileHandler.cleanUp();
    }
}

