/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.filter.sampling.infiles.stratified.sampling;

import ai.libs.jaicore.basic.TempFileHandler;
import ai.libs.jaicore.ml.core.filter.sampling.infiles.stratified.sampling.IStratiFileAssigner;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.api4.java.algorithm.exceptions.AlgorithmException;

public class ClassStratiFileAssigner
implements IStratiFileAssigner {
    private TempFileHandler tempFileHandler;
    private String arffHeader;
    private int targetAttribute;
    private Map<String, String> classToStratumMapping;
    private Map<String, Integer> stratiSizes;

    public ClassStratiFileAssigner(int targetAttribute) {
        this.targetAttribute = targetAttribute;
        this.classToStratumMapping = new HashMap<String, String>();
        this.stratiSizes = new HashMap<String, Integer>();
    }

    public ClassStratiFileAssigner() {
        this.targetAttribute = -1;
        this.classToStratumMapping = new HashMap<String, String>();
        this.stratiSizes = new HashMap<String, Integer>();
    }

    @Override
    public void setTempFileHandler(TempFileHandler tempFileHandler) {
        this.tempFileHandler = tempFileHandler;
    }

    @Override
    public void setArffHeader(String arffHeader) {
        this.arffHeader = arffHeader;
    }

    @Override
    public void assignDatapoint(String datapoint) throws AlgorithmException {
        String uuid;
        String[] features = datapoint.split(",");
        String c = this.targetAttribute == -1 ? features[features.length - 1] : features[this.targetAttribute];
        if (!this.classToStratumMapping.containsKey(c)) {
            try {
                uuid = this.createNewStratumFile(c);
            }
            catch (IOException e) {
                throw new AlgorithmException("Was not able to create a new temporary file for a stratum.", (Throwable)e);
            }
        } else {
            uuid = this.classToStratumMapping.get(c);
        }
        try {
            this.tempFileHandler.getFileWriterForTempFile(uuid).write(datapoint + "\n");
            this.tempFileHandler.getFileWriterForTempFile(uuid).flush();
            this.stratiSizes.put(uuid, this.stratiSizes.get(uuid) + 1);
        }
        catch (IOException e) {
            throw new AlgorithmException("Was not able to write the datapoint into the corresponding stratum file.", (Throwable)e);
        }
    }

    @Override
    public Map<String, Integer> getAllCreatedStrati() {
        return this.stratiSizes;
    }

    private String createNewStratumFile(String c) throws IOException {
        String uuid = this.tempFileHandler.createTempFile();
        this.tempFileHandler.getFileWriterForTempFile(uuid).write(this.arffHeader);
        this.tempFileHandler.getFileWriterForTempFile(uuid).flush();
        this.classToStratumMapping.put(c, uuid);
        this.stratiSizes.put(uuid, 0);
        return uuid;
    }
}

