/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.filter.sampling.inmemory;

import ai.libs.jaicore.basic.algorithm.AAlgorithm;
import ai.libs.jaicore.basic.algorithm.EAlgorithmState;
import ai.libs.jaicore.ml.core.filter.sampling.inmemory.SampleComplementComputer;
import org.api4.java.ai.ml.core.dataset.IDataset;
import org.api4.java.ai.ml.core.dataset.IInstance;
import org.api4.java.ai.ml.core.exception.DatasetCreationException;
import org.api4.java.ai.ml.core.filter.unsupervised.sampling.ISamplingAlgorithm;
import org.api4.java.algorithm.events.IAlgorithmEvent;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;

public abstract class ASamplingAlgorithm<D extends IDataset<?>>
extends AAlgorithm<D, D>
implements ISamplingAlgorithm<D> {
    protected int sampleSize = -1;
    protected D sample = null;
    private final Caps<?> caps;

    protected ASamplingAlgorithm(D input) {
        this(input, ((IInstance)input.get(0)).getClass());
    }

    protected <I extends IInstance> ASamplingAlgorithm(D input, Class<I> instanceClass) {
        super(input);
        D dsCopy = input;
        if (!instanceClass.isInstance(input.get(0))) {
            throw new IllegalArgumentException("The class " + instanceClass.getName() + " is not a valid cast for the given dataset.");
        }
        this.caps = new Caps(dsCopy);
    }

    public void setSampleSize(int size) {
        this.sampleSize = size;
    }

    public void setSampleSize(double relativeSize) {
        if (relativeSize <= 0.0 || relativeSize >= 1.0) {
            throw new IllegalArgumentException("Illegal relative sample size " + relativeSize + ". Must be between 0 and 1 (both exclusive).");
        }
        this.setSampleSize((int)Math.round((double)((IDataset)this.getInput()).size() * relativeSize));
    }

    public D call() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmException, AlgorithmTimeoutedException {
        ((Caps)this.caps).computeSample();
        return (D)((Caps)this.caps).dataForSample;
    }

    protected IAlgorithmEvent doInactiveStep() throws AlgorithmException {
        if (this.sample.size() < this.sampleSize) {
            throw new AlgorithmException("Expected sample size was not reached before termination. Current sample size is " + this.sample.size());
        }
        return this.terminate();
    }

    public D nextSample() throws InterruptedException, DatasetCreationException {
        try {
            return this.call();
        }
        catch (AlgorithmException | AlgorithmExecutionCanceledException | AlgorithmTimeoutedException e) {
            throw new DatasetCreationException(e);
        }
    }

    public D getComplementOfLastSample() throws DatasetCreationException, InterruptedException {
        return (D)this.caps.getComplement();
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    private class Caps<I extends IInstance> {
        private IDataset<I> cloneOfOriginal;
        private IDataset<I> dataForSample;

        public Caps(IDataset<I> clone) {
            this.cloneOfOriginal = clone;
        }

        private void computeSample() throws AlgorithmException, AlgorithmTimeoutedException, InterruptedException, AlgorithmExecutionCanceledException {
            if (ASamplingAlgorithm.this.sampleSize == -1) {
                throw new AlgorithmException("No valid sample size specified");
            }
            if (ASamplingAlgorithm.this.sampleSize == 0) {
                ASamplingAlgorithm.this.logger.warn("Sample size is 0, so an empty data set is returned!");
                try {
                    this.dataForSample = ((IDataset)ASamplingAlgorithm.this.getInput()).createEmptyCopy();
                    return;
                }
                catch (DatasetCreationException e) {
                    throw new AlgorithmException("Could not create a copy of the dataset.", (Throwable)e);
                }
            }
            IDataset dataset = (IDataset)ASamplingAlgorithm.this.getInput();
            if (dataset == null || dataset.isEmpty()) {
                throw new AlgorithmException("No dataset or an empty dataset was given as an input.");
            }
            if (dataset.size() < ASamplingAlgorithm.this.sampleSize) {
                throw new AlgorithmException("Specified sample size is bigger than the dataset.");
            }
            if (dataset.size() == ASamplingAlgorithm.this.sampleSize) {
                ASamplingAlgorithm.this.logger.warn("Sample size and data set size are equal. Returning the original data set");
                this.dataForSample = dataset;
            } else {
                ASamplingAlgorithm.this.setState(EAlgorithmState.CREATED);
                ASamplingAlgorithm.this.setDeadline();
                ASamplingAlgorithm.this.logger.info("Now running actual sample routine. Timeout is {}. Remaining time: {}", (Object)ASamplingAlgorithm.this.getTimeout(), (Object)ASamplingAlgorithm.this.getRemainingTimeToDeadline());
                int i = 0;
                while (ASamplingAlgorithm.this.hasNext()) {
                    if (i++ % 100 == 0) {
                        ASamplingAlgorithm.this.checkAndConductTermination();
                    }
                    ASamplingAlgorithm.this.nextWithException();
                }
                this.dataForSample = ASamplingAlgorithm.this.sample;
            }
        }

        public IDataset<I> getComplement() throws DatasetCreationException, InterruptedException {
            return new SampleComplementComputer().getComplement(this.cloneOfOriginal, this.dataForSample);
        }
    }
}

