/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.filter.sampling.inmemory;

import ai.libs.jaicore.ml.core.filter.sampling.SampleElementAddedEvent;
import ai.libs.jaicore.ml.core.filter.sampling.inmemory.ASamplingAlgorithm;
import java.util.List;
import org.apache.commons.math3.ml.clustering.CentroidCluster;
import org.apache.commons.math3.ml.clustering.Clusterable;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.distance.ManhattanDistance;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledDataset;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledInstance;
import org.api4.java.algorithm.IAlgorithm;
import org.api4.java.algorithm.events.IAlgorithmEvent;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;

public abstract class ClusterSampling<I extends ILabeledInstance & Clusterable, D extends ILabeledDataset<I>>
extends ASamplingAlgorithm<D> {
    protected List<CentroidCluster<I>> clusterResults = null;
    protected int currentCluster = 0;
    protected DistanceMeasure distanceMeassure = new ManhattanDistance();
    protected long seed;

    protected ClusterSampling(long seed, D input) {
        super(input);
        this.seed = seed;
    }

    protected ClusterSampling(long seed, DistanceMeasure dist, D input) {
        super(input);
        this.seed = seed;
        this.distanceMeassure = dist;
    }

    public List<CentroidCluster<I>> getClusterResults() {
        return this.clusterResults;
    }

    public void setClusterResults(List<CentroidCluster<I>> clusterResults) {
        this.clusterResults = clusterResults;
    }

    public void setDistanceMeassure(DistanceMeasure distanceMeassure) {
        this.distanceMeassure = distanceMeassure;
    }

    public IAlgorithmEvent doAlgorithmStep() throws AlgorithmTimeoutedException, InterruptedException, AlgorithmExecutionCanceledException {
        if (this.currentCluster < this.clusterResults.size()) {
            int i;
            CentroidCluster<I> cluster = this.clusterResults.get(this.currentCluster++);
            boolean same = true;
            int n = cluster.getPoints().size();
            for (i = 1; i < n; ++i) {
                if (i % 1000 == 0) {
                    this.checkAndConductTermination();
                }
                if (((ILabeledInstance)cluster.getPoints().get(i - 1)).getLabel().equals(((ILabeledInstance)cluster.getPoints().get(i)).getLabel())) continue;
                same = false;
                break;
            }
            if (same) {
                ILabeledInstance near = (ILabeledInstance)cluster.getPoints().get(0);
                double dist = Double.MAX_VALUE;
                for (ILabeledInstance p : cluster.getPoints()) {
                    double newDist = this.distanceMeassure.compute(((Clusterable)p).getPoint(), cluster.getCenter().getPoint());
                    if (!(newDist < dist)) continue;
                    near = p;
                    dist = newDist;
                }
                ((ILabeledDataset)this.sample).add((Object)near);
            } else {
                for (i = 0; i < cluster.getPoints().size(); ++i) {
                    ((ILabeledDataset)this.sample).add((Object)((ILabeledInstance)cluster.getPoints().get(i)));
                }
            }
            return new SampleElementAddedEvent((IAlgorithm<?, ?>)this);
        }
        return this.terminate();
    }
}

