/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.filter.sampling.inmemory;

import ai.libs.jaicore.ml.clustering.learner.GMeans;
import ai.libs.jaicore.ml.core.filter.sampling.IClusterableInstance;
import ai.libs.jaicore.ml.core.filter.sampling.inmemory.ClusterSampling;
import java.util.Collection;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledDataset;
import org.api4.java.ai.ml.core.exception.DatasetCreationException;
import org.api4.java.algorithm.events.IAlgorithmEvent;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;

public class GmeansSampling<I extends IClusterableInstance, D extends ILabeledDataset<I>>
extends ClusterSampling<I, D> {
    public GmeansSampling(long seed, DistanceMeasure dist, D input) {
        super(seed, dist, input);
        if (input.size() > 1000) {
            throw new IllegalArgumentException("GMeans does not support datasets with more than 1000 points, because it has quadratic (non-interruptible) runtime.");
        }
    }

    public GmeansSampling(long seed, D input) {
        super(seed, input);
        if (input.size() > 1000) {
            throw new IllegalArgumentException("GMeans does not support datasets with more than 1000 points, because it has quadratic (non-interruptible) runtime.");
        }
    }

    public IAlgorithmEvent nextWithException() throws AlgorithmException, InterruptedException, AlgorithmTimeoutedException, AlgorithmExecutionCanceledException {
        switch (this.getState()) {
            case CREATED: {
                try {
                    this.sample = ((ILabeledDataset)this.getInput()).createEmptyCopy();
                }
                catch (DatasetCreationException e) {
                    throw new AlgorithmException("Could not create a copy of the dataset.", (Throwable)e);
                }
                if (this.clusterResults == null) {
                    GMeans gMeansCluster = new GMeans((Collection)this.getInput(), this.distanceMeassure, this.seed);
                    this.clusterResults = gMeansCluster.cluster();
                }
                return this.activate();
            }
            case ACTIVE: {
                return this.doAlgorithmStep();
            }
        }
        throw new IllegalStateException("Unknown algorithm state " + this.getState());
    }
}

