/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.filter.sampling.inmemory;

import ai.libs.jaicore.ml.core.filter.sampling.inmemory.ClusterSampling;
import java.util.Collection;
import org.apache.commons.math3.ml.clustering.Clusterable;
import org.apache.commons.math3.ml.clustering.KMeansPlusPlusClusterer;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.commons.math3.random.RandomGenerator;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledDataset;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledInstance;
import org.api4.java.ai.ml.core.exception.DatasetCreationException;
import org.api4.java.algorithm.events.IAlgorithmEvent;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;

public class KmeansSampling<I extends ILabeledInstance & Clusterable, D extends ILabeledDataset<I>>
extends ClusterSampling<I, D> {
    private int k;

    public KmeansSampling(long seed, int k, D input) {
        super(seed, input);
        this.k = k;
        if (input.size() > 1000) {
            throw new IllegalArgumentException("KMeansSampling does not support datasets with more than 1000 points, because it has quadratic (non-interruptible) runtime.");
        }
    }

    public KmeansSampling(long seed, DistanceMeasure dist, D input) {
        super(seed, dist, input);
        this.k = -1;
        if (input.size() > 1000) {
            throw new IllegalArgumentException("KMeansSampling does not support datasets with more than 1000 points, because it has quadratic (non-interruptible) runtime.");
        }
    }

    public KmeansSampling(long seed, int k, DistanceMeasure dist, D input) {
        super(seed, dist, input);
        this.k = k;
    }

    public IAlgorithmEvent nextWithException() throws AlgorithmException, InterruptedException, AlgorithmTimeoutedException, AlgorithmExecutionCanceledException {
        switch (this.getState()) {
            case CREATED: {
                try {
                    this.sample = ((ILabeledDataset)this.getInput()).createEmptyCopy();
                }
                catch (DatasetCreationException e) {
                    throw new AlgorithmException("Could not create a copy of the dataset.", (Throwable)e);
                }
                JDKRandomGenerator r = new JDKRandomGenerator();
                r.setSeed(this.seed);
                if (this.k == -1) {
                    this.k = this.sampleSize;
                }
                if (this.clusterResults == null) {
                    KMeansPlusPlusClusterer kMeansCluster = new KMeansPlusPlusClusterer(this.k, -1, this.distanceMeassure, (RandomGenerator)r);
                    this.clusterResults = kMeansCluster.cluster((Collection)this.getInput());
                }
                return this.activate();
            }
            case ACTIVE: {
                return this.doAlgorithmStep();
            }
        }
        throw new IllegalStateException("Unknown algorithm state " + this.getState());
    }
}

