/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.filter.sampling.inmemory;

import java.util.HashMap;
import java.util.Map;
import org.api4.java.ai.ml.core.dataset.IDataset;
import org.api4.java.ai.ml.core.dataset.IInstance;
import org.api4.java.ai.ml.core.exception.DatasetCreationException;

public class SampleComplementComputer {
    public <I extends IInstance, D extends IDataset<I>> D getComplement(D originalData, D sample) throws DatasetCreationException, InterruptedException {
        if (sample == null) {
            throw new IllegalStateException("Sample computation has not started yet.");
        }
        if (originalData.isEmpty()) {
            throw new IllegalArgumentException("Cannot compute complement of an empty base set!");
        }
        HashMap<Object, Integer> frequenciesInInput = new HashMap<Object, Integer>();
        HashMap<Object, Integer> frequenciesInSubSample = new HashMap<Object, Integer>();
        HashMap<Object, Integer> frequenciesInComplement = new HashMap<Object, Integer>();
        for (Object instance : originalData) {
            frequenciesInInput.put(instance, frequenciesInInput.computeIfAbsent(instance, k -> 0) + 1);
            frequenciesInComplement.put(instance, 0);
            frequenciesInSubSample.put(instance, 0);
        }
        for (Object instance : sample) {
            frequenciesInSubSample.put(instance, frequenciesInSubSample.computeIfAbsent(instance, k -> 0) + 1);
        }
        IDataset complement = originalData.createEmptyCopy();
        for (IInstance instance : originalData) {
            int frequencyInComplement = (Integer)frequenciesInComplement.get(instance);
            if ((Integer)frequenciesInSubSample.get(instance) + frequencyInComplement >= (Integer)frequenciesInInput.get(instance)) continue;
            complement.add((Object)instance);
            frequenciesInComplement.put(instance, frequencyInComplement + 1);
        }
        if (sample.size() + complement.size() != originalData.size()) {
            throw new IllegalStateException("The input set of size " + originalData.size() + " has been reduced to " + sample.size() + " + " + complement.size() + ". This is not plausible.");
        }
        for (Map.Entry instanceWithFrequency : frequenciesInInput.entrySet()) {
            Object inst = instanceWithFrequency.getKey();
            int frequencyNow = (Integer)frequenciesInSubSample.get(inst) + (Integer)frequenciesInComplement.get(inst);
            if ((Integer)instanceWithFrequency.getValue() == frequencyNow) continue;
            throw new IllegalStateException("Frequency of instance " + inst + " was " + instanceWithFrequency.getValue() + " but is now " + frequencyNow);
        }
        return (D)complement;
    }
}

