/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.filter.sampling.inmemory;

import ai.libs.jaicore.ml.core.dataset.DatasetDeriver;
import ai.libs.jaicore.ml.core.filter.sampling.SampleElementAddedEvent;
import ai.libs.jaicore.ml.core.filter.sampling.inmemory.ASamplingAlgorithm;
import java.util.Comparator;
import java.util.Random;
import org.api4.java.ai.ml.core.dataset.IInstance;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledDataset;
import org.api4.java.ai.ml.core.exception.DatasetCreationException;
import org.api4.java.algorithm.IAlgorithm;
import org.api4.java.algorithm.events.IAlgorithmEvent;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;

public class SystematicSampling<D extends ILabeledDataset<?>>
extends ASamplingAlgorithm<D> {
    private DatasetDeriver<D> sampleBuilder;
    private Random random;
    private D sortedDataset = null;
    private int k;
    private int startIndex;
    private int index;
    private Comparator<IInstance> datapointComparator = (o1, o2) -> {
        double[] v1 = o1.getPoint();
        double[] v2 = o2.getPoint();
        for (int i = 0; i < Math.min(v1.length, v2.length); ++i) {
            int c = Double.compare(v1[i], v2[i]);
            if (c == 0) continue;
            return c;
        }
        return 0;
    };

    public SystematicSampling(Random random, D input) {
        super(input);
        this.random = random;
    }

    public SystematicSampling(Random random, Comparator<IInstance> datapointComparator, D input) {
        this(random, input);
        this.datapointComparator = datapointComparator;
    }

    public IAlgorithmEvent nextWithException() throws AlgorithmException, InterruptedException, AlgorithmTimeoutedException, AlgorithmExecutionCanceledException {
        switch (this.getState()) {
            case CREATED: {
                try {
                    if (this.sortedDataset == null) {
                        this.sortedDataset = (ILabeledDataset)((ILabeledDataset)this.getInput()).createCopy();
                        this.sortedDataset.sort(this.datapointComparator);
                        this.sampleBuilder = new DatasetDeriver<D>(this.sortedDataset);
                    }
                }
                catch (DatasetCreationException e) {
                    throw new AlgorithmException("Could not create a copy of the dataset.", (Throwable)e);
                }
                this.startIndex = this.random.nextInt(this.sortedDataset.size());
                this.k = this.sortedDataset.size() / this.sampleSize;
                this.index = 0;
                return this.activate();
            }
            case ACTIVE: {
                if (this.sampleBuilder.currentSizeOfTarget() < this.sampleSize) {
                    if (this.index % 100 == 0) {
                        this.checkAndConductTermination();
                    }
                    int e = (this.startIndex + this.index++ * this.k) % this.sortedDataset.size();
                    this.sampleBuilder.add(e);
                    return new SampleElementAddedEvent((IAlgorithm<?, ?>)this);
                }
                try {
                    this.sample = this.sampleBuilder.build();
                }
                catch (DatasetCreationException e) {
                    throw new AlgorithmException("Could not build the sample.", (Throwable)e);
                }
                return this.terminate();
            }
            case INACTIVE: {
                this.doInactiveStep();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown algorithm state " + this.getState());
            }
        }
        return null;
    }

    public D getSortedDataset() {
        return this.sortedDataset;
    }

    public void setSortedDataset(D sortedDataset) {
        this.sortedDataset = sortedDataset;
    }
}

