/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.filter.sampling.inmemory.factories;

import ai.libs.jaicore.ml.core.filter.sampling.inmemory.KmeansSampling;
import ai.libs.jaicore.ml.core.filter.sampling.inmemory.factories.ASampleAlgorithmFactory;
import ai.libs.jaicore.ml.core.filter.sampling.inmemory.factories.interfaces.IRerunnableSamplingAlgorithmFactory;
import java.util.Random;
import org.apache.commons.math3.ml.clustering.Clusterable;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.distance.ManhattanDistance;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledDataset;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledInstance;

public class KmeansSamplingFactory<I extends ILabeledInstance & Clusterable, D extends ILabeledDataset<I>>
extends ASampleAlgorithmFactory<D, KmeansSampling<I, D>>
implements IRerunnableSamplingAlgorithmFactory<D, KmeansSampling<I, D>> {
    private KmeansSampling<I, D> previousRun;
    private int k = -1;
    private long clusterSeed = System.currentTimeMillis();
    private DistanceMeasure distanceMeassure = new ManhattanDistance();

    @Override
    public void setPreviousRun(KmeansSampling<I, D> previousRun) {
        this.previousRun = previousRun;
    }

    public void setK(int k) {
        this.k = k;
    }

    public void setClusterSeed(long clusterSeed) {
        this.clusterSeed = clusterSeed;
    }

    public void setDistanceMeassure(DistanceMeasure distanceMeassure) {
        this.distanceMeassure = distanceMeassure;
    }

    @Override
    public KmeansSampling<I, D> getAlgorithm(int sampleSize, D inputDataset, Random random) {
        int kValue = sampleSize;
        if (this.k > 0) {
            kValue = this.k;
        }
        KmeansSampling kmeansSampling = new KmeansSampling(this.clusterSeed, kValue, inputDataset);
        kmeansSampling.setSampleSize(sampleSize);
        kmeansSampling.setDistanceMeassure(this.distanceMeassure);
        if (this.previousRun != null && this.previousRun.getClusterResults() != null) {
            kmeansSampling.setClusterResults(this.previousRun.getClusterResults());
        }
        return kmeansSampling;
    }
}

