/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.filter.sampling.inmemory.factories;

import ai.libs.jaicore.ml.core.filter.sampling.inmemory.casecontrol.OSMAC;
import ai.libs.jaicore.ml.core.filter.sampling.inmemory.factories.ASampleAlgorithmFactory;
import ai.libs.jaicore.ml.core.filter.sampling.inmemory.factories.SimpleRandomSamplingFactory;
import ai.libs.jaicore.ml.core.filter.sampling.inmemory.factories.interfaces.IRerunnableSamplingAlgorithmFactory;
import java.util.Objects;
import java.util.Random;
import org.api4.java.ai.ml.classification.IClassifier;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledDataset;

public class OSMACSamplingFactory
extends ASampleAlgorithmFactory<ILabeledDataset<?>, OSMAC<ILabeledDataset<?>>>
implements IRerunnableSamplingAlgorithmFactory<ILabeledDataset<?>, OSMAC<ILabeledDataset<?>>> {
    private OSMAC<ILabeledDataset<?>> previousRun;
    private int preSampleSize = -1;
    private IClassifier pilot;

    public void setPreSampleSize(int preSampleSize) {
        this.preSampleSize = preSampleSize;
    }

    public IClassifier getPilot() {
        return this.pilot;
    }

    public void setPilot(IClassifier pilot) {
        this.pilot = pilot;
    }

    @Override
    public void setPreviousRun(OSMAC<ILabeledDataset<?>> previousRun) {
        this.previousRun = previousRun;
    }

    @Override
    public OSMAC<ILabeledDataset<?>> getAlgorithm(int sampleSize, ILabeledDataset<?> inputDataset, Random random) {
        Objects.requireNonNull(inputDataset);
        Objects.requireNonNull(this.pilot);
        if (inputDataset.isEmpty()) {
            throw new IllegalArgumentException("Cannot create OSMAC for an empty dataset.");
        }
        SimpleRandomSamplingFactory subSampleFactory = new SimpleRandomSamplingFactory();
        subSampleFactory.setRandom(random);
        OSMAC osmac = new OSMAC(random, inputDataset, subSampleFactory, this.preSampleSize, this.pilot);
        if (this.previousRun != null && this.previousRun.getAcceptanceThresholds() != null) {
            osmac.setAcceptanceTresholds(this.previousRun.getAcceptanceThresholds());
        }
        osmac.setSampleSize(sampleSize);
        return osmac;
    }
}

