/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.filter.sampling.inmemory.factories;

import ai.libs.jaicore.ml.core.filter.sampling.inmemory.SystematicSampling;
import ai.libs.jaicore.ml.core.filter.sampling.inmemory.factories.ASampleAlgorithmFactory;
import ai.libs.jaicore.ml.core.filter.sampling.inmemory.factories.interfaces.IRerunnableSamplingAlgorithmFactory;
import java.util.Comparator;
import java.util.Random;
import org.api4.java.ai.ml.core.dataset.IInstance;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledDataset;

public class SystematicSamplingFactory<D extends ILabeledDataset<?>>
extends ASampleAlgorithmFactory<D, SystematicSampling<D>>
implements IRerunnableSamplingAlgorithmFactory<D, SystematicSampling<D>> {
    private Comparator<IInstance> datapointComparator = null;
    private SystematicSampling<D> previousRun = null;

    public void setDatapointComparator(Comparator<IInstance> datapointComparator) {
        this.datapointComparator = datapointComparator;
    }

    @Override
    public void setPreviousRun(SystematicSampling<D> previousRun) {
        this.previousRun = previousRun;
    }

    @Override
    public SystematicSampling<D> getAlgorithm(int sampleSize, D inputDataset, Random random) {
        SystematicSampling<D> systematicSampling = this.datapointComparator != null ? new SystematicSampling<D>(random, this.datapointComparator, inputDataset) : new SystematicSampling<D>(random, inputDataset);
        systematicSampling.setSampleSize(sampleSize);
        if (this.previousRun != null && this.previousRun.getSortedDataset() != null) {
            systematicSampling.setSortedDataset(this.previousRun.getSortedDataset());
        }
        return systematicSampling;
    }
}

