/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.learner;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.api4.java.ai.ml.core.dataset.IDataSource;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledDataset;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledInstance;
import org.api4.java.ai.ml.core.evaluation.IPrediction;
import org.api4.java.ai.ml.core.evaluation.IPredictionBatch;
import org.api4.java.ai.ml.core.exception.LearnerConfigurationFailedException;
import org.api4.java.ai.ml.core.exception.PredictionException;
import org.api4.java.ai.ml.core.exception.TrainingException;
import org.api4.java.ai.ml.core.learner.ISupervisedLearner;

public abstract class ASupervisedLearner<I extends ILabeledInstance, D extends ILabeledDataset<? extends I>, P extends IPrediction, B extends IPredictionBatch>
implements ISupervisedLearner<I, D> {
    private Map<String, Object> config;

    protected ASupervisedLearner(Map<String, Object> config) {
        this.config = config;
    }

    protected ASupervisedLearner() {
        this.config = new HashMap<String, Object>();
    }

    public P fitAndPredict(D dTrain, I xTest) throws TrainingException, PredictionException, InterruptedException {
        this.fit((IDataSource)dTrain);
        return this.predict(xTest);
    }

    public B fitAndPredict(D dTrain, I[] xTest) throws TrainingException, PredictionException, InterruptedException {
        this.fit((IDataSource)dTrain);
        return (B)this.predict((I)xTest);
    }

    public B fitAndPredict(D dTrain, D dTest) throws TrainingException, PredictionException, InterruptedException {
        this.fit((IDataSource)dTrain);
        return (B)this.predict((I)dTest);
    }

    public B predict(D dTest) throws PredictionException, InterruptedException {
        Class<?> clazz = ((ILabeledInstance)dTest.iterator().next()).getClass();
        ILabeledInstance[] instancesAsArray = (ILabeledInstance[])Array.newInstance(clazz, dTest.size());
        for (int i = 0; i < dTest.size(); ++i) {
            instancesAsArray[i] = (ILabeledInstance)dTest.get(i);
        }
        return (B)this.predict((I)instancesAsArray);
    }

    public abstract P predict(I var1) throws PredictionException, InterruptedException;

    public abstract B predict(I[] var1) throws PredictionException, InterruptedException;

    public void setConfig(Map<String, Object> config) throws LearnerConfigurationFailedException, InterruptedException {
        this.config = config;
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }
}

