/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.functionprediction.learner.learningcurveextrapolation.lcnet;

import ai.libs.jaicore.logging.LoggerUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import org.api4.java.ai.ml.core.exception.PredictionException;
import org.api4.java.ai.ml.core.exception.TrainingException;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LCNetClient {
    private Logger logger = LoggerFactory.getLogger(LCNetClient.class);
    private static final String SERVER_ADDRESS = "http://localhost:5001/";

    public void train(int[] xValues, double[] yValues, int dataSetSize, double[][] configurations, String identifier) throws TrainingException {
        HttpURLConnection httpCon;
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("xValues must contain the same number of values as yValues");
        }
        if (xValues.length != configurations.length) {
            throw new IllegalArgumentException("xValues must contain as much numbers as configurations configurations");
        }
        try {
            httpCon = this.establishHttpCon("train", identifier);
        }
        catch (IOException e1) {
            throw new TrainingException("Could not train", (Throwable)e1);
        }
        JSONObject jsonData = new JSONObject();
        for (int i = 0; i < xValues.length; ++i) {
            double[] tmpArray = Arrays.copyOf(configurations[i], configurations[i].length + 2);
            tmpArray[configurations[i].length] = (double)xValues[i] / (double)dataSetSize;
            tmpArray[configurations[i].length + 1] = yValues[i];
            JSONArray allValues = new JSONArray((Object)tmpArray);
            jsonData.put(Integer.toString(i), (Object)allValues);
        }
        try {
            OutputStreamWriter out = new OutputStreamWriter(httpCon.getOutputStream());
            out.write(jsonData.toString());
            out.close();
            httpCon.getInputStream();
        }
        catch (IOException e) {
            this.logger.error(LoggerUtil.getExceptionInfo((Throwable)e));
        }
    }

    public double predict(int xValue, double[] configurations, String identifier) throws PredictionException {
        try {
            String inputLine;
            HttpURLConnection httpCon = this.establishHttpCon("predict", identifier);
            JSONObject jsonData = new JSONObject();
            double[] tmpArray = Arrays.copyOf(configurations, configurations.length + 1);
            tmpArray[configurations.length] = xValue;
            JSONArray allValues = new JSONArray((Object)tmpArray);
            jsonData.put("0", (Object)allValues);
            OutputStreamWriter out = new OutputStreamWriter(httpCon.getOutputStream());
            BufferedReader in = null;
            out.write(jsonData.toString());
            out.close();
            in = new BufferedReader(new InputStreamReader(httpCon.getInputStream()));
            StringBuilder inputBuilder = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                inputBuilder.append(inputLine);
            }
            HashMap entireInput = null;
            entireInput = (HashMap)new ObjectMapper().readValue(inputBuilder.toString(), HashMap.class);
            return (Double)entireInput.get("prediction");
        }
        catch (IOException e1) {
            throw new PredictionException("Could not predict", (Throwable)e1);
        }
    }

    public void deleteNet(String identifier) throws IOException {
        HttpURLConnection httpCon = this.establishHttpCon("delete", identifier);
        try (OutputStreamWriter out = new OutputStreamWriter(httpCon.getOutputStream());){
            httpCon.getInputStream();
        }
    }

    private HttpURLConnection establishHttpCon(String urlParameter, String identifier) throws IOException {
        URL url = new URL(SERVER_ADDRESS + urlParameter + "/" + identifier);
        HttpURLConnection httpCon = null;
        httpCon = (HttpURLConnection)url.openConnection();
        httpCon.setDoOutput(true);
        try {
            httpCon.setRequestMethod("PUT");
        }
        catch (ProtocolException e) {
            this.logger.error(LoggerUtil.getExceptionInfo((Throwable)e));
        }
        return httpCon;
    }
}

