/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.functionprediction.learner.learningcurveextrapolation.lcnet;

import ai.libs.jaicore.ml.functionprediction.learner.learningcurveextrapolation.InvalidAnchorPointsException;
import ai.libs.jaicore.ml.functionprediction.learner.learningcurveextrapolation.LearningCurveExtrapolationMethod;
import ai.libs.jaicore.ml.functionprediction.learner.learningcurveextrapolation.lcnet.LCNetClient;
import ai.libs.jaicore.ml.functionprediction.learner.learningcurveextrapolation.lcnet.PointWiseLearningCurve;
import java.io.IOException;
import org.api4.java.ai.ml.core.evaluation.learningcurve.ILearningCurve;
import org.api4.java.ai.ml.core.exception.TrainingException;

public class LCNetExtrapolationMethod
implements LearningCurveExtrapolationMethod {
    private LCNetClient lcNet = new LCNetClient();
    private String identifier;
    private double[] configurations;

    public LCNetExtrapolationMethod(String identifier) {
        this.identifier = identifier;
        this.configurations = null;
    }

    public void setConfigurations(double[] configurations) {
        this.configurations = configurations;
    }

    @Override
    public ILearningCurve extrapolateLearningCurveFromAnchorPoints(int[] xValues, double[] yValues, int dataSetSize) throws InvalidAnchorPointsException {
        if (this.configurations == null) {
            throw new UnsupportedOperationException("Configurations is not allowed to be null");
        }
        return new PointWiseLearningCurve(dataSetSize, this.configurations, this.identifier);
    }

    public void deleteNet() throws IOException {
        this.lcNet.deleteNet(this.identifier);
    }

    public void trainNet(int[] xValues, double[] yValues, int dataSetSize, double[][] configurations) throws TrainingException {
        this.lcNet.train(xValues, yValues, dataSetSize, configurations, this.identifier);
    }
}

