/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.ranking.dyad.dataset;

import ai.libs.jaicore.ml.ranking.dyad.dataset.INDArrayDyadRankingInstance;
import ai.libs.jaicore.ml.ranking.label.learner.clusterbased.customdatatypes.Ranking;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.api4.java.ai.ml.ranking.dyad.dataset.IDyad;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public abstract class ADyadRankingInstance
implements INDArrayDyadRankingInstance {
    @Override
    public INDArray toMatrix() {
        ArrayList<INDArray> dyadList = new ArrayList<INDArray>(this.getNumberOfRankedElements());
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            IDyad dyad = (IDyad)iterator.next();
            INDArray dyadVector = Nd4j.create((double[])dyad.toDoubleVector());
            dyadList.add(dyadVector);
        }
        INDArray dyadMatrix = Nd4j.vstack(dyadList);
        return dyadMatrix;
    }

    public double[] getPoint() {
        throw new UnsupportedOperationException("Cannot create vector representation of ranking instance.");
    }

    public void removeColumn(int columnPos) {
        throw new UnsupportedOperationException("Cannot create vector representation of ranking instance.");
    }

    public Object[] getAttributes() {
        return new Object[]{this.getAttributeValue(0)};
    }

    protected void assertOnlyDyadsInCollection(Collection<?> collection) {
        boolean noneDyadInCollection = collection.stream().anyMatch(o -> !(o instanceof IDyad));
        if (noneDyadInCollection) {
            throw new IllegalArgumentException("Cannot set collection with non-dyad element as attribute value.");
        }
    }

    protected void assertNonEmptyCollection(Collection<?> collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Cannot work with empty collection.");
        }
    }

    public abstract Set<IDyad> getAttributeValue(int var1);

    public Set<IDyad> getDyads() {
        return this.getAttributeValue(0);
    }

    public abstract void setDyads(Set<IDyad> var1);

    public abstract void setRanking(Ranking<IDyad> var1);

    public void setLabel(Object obj) {
        if (!(obj instanceof List)) {
            throw new IllegalArgumentException("Label " + obj + " is not of type List.");
        }
        List list = (List)obj;
        this.assertNonEmptyCollection(list);
        this.assertOnlyDyadsInCollection(list);
        Set<IDyad> dyads = this.getDyads();
        boolean unknownDyadInList = list.stream().anyMatch(o -> !dyads.contains(o));
        if (unknownDyadInList) {
            throw new IllegalArgumentException("Cannot set list with unknown dyad element as label.");
        }
        Ranking<IDyad> ranking = new Ranking<IDyad>(list.stream().map(o -> (IDyad)o).collect(Collectors.toList()));
        this.setRanking(ranking);
    }

    public void setAttributeValue(int pos, Object value) {
        if (!(value instanceof Collection)) {
            throw new IllegalArgumentException("Attribute value " + value + " is not of type Collection.");
        }
        Collection collection = (Collection)value;
        this.assertNonEmptyCollection(collection);
        this.assertOnlyDyadsInCollection(collection);
        Set<IDyad> dyads = collection.stream().map(o -> (IDyad)o).collect(Collectors.toSet());
        this.setDyads(dyads);
    }
}

