/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.ranking.dyad.dataset;

import ai.libs.jaicore.ml.ranking.dyad.dataset.ADyadRankingInstance;
import ai.libs.jaicore.ml.ranking.label.learner.clusterbased.customdatatypes.Ranking;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.api4.java.ai.ml.ranking.IRanking;
import org.api4.java.ai.ml.ranking.dyad.dataset.IDyad;
import org.api4.java.ai.ml.ranking.dyad.dataset.IDyadRankingInstance;

public class DenseDyadRankingInstance
extends ADyadRankingInstance {
    private Set<IDyad> dyads;
    private Ranking<IDyad> rankingOverDyads;

    public DenseDyadRankingInstance(Set<IDyad> dyads) {
        this.dyads = new HashSet<IDyad>(dyads);
        this.rankingOverDyads = new Ranking();
    }

    public DenseDyadRankingInstance(List<IDyad> dyads) {
        this.dyads = new HashSet<IDyad>(dyads);
        this.rankingOverDyads = new Ranking<IDyad>((Collection<IDyad>)dyads);
    }

    public Iterator<IDyad> iterator() {
        return this.dyads.iterator();
    }

    @Override
    public Set<IDyad> getAttributeValue(int pos) {
        if (pos == 0) {
            return Collections.unmodifiableSet(this.dyads);
        }
        throw new IllegalArgumentException("No attribute at position " + pos + ".");
    }

    public IRanking<IDyad> getLabel() {
        return this.rankingOverDyads;
    }

    public int getNumberOfRankedElements() {
        return this.dyads.size();
    }

    public boolean equals(Object o) {
        if (!(o instanceof IDyadRankingInstance)) {
            return false;
        }
        IDyadRankingInstance drInstance = (IDyadRankingInstance)o;
        for (int i = 0; i < drInstance.getNumberOfRankedElements(); ++i) {
            if (drInstance.getAttributeValue(i).equals(this.getAttributeValue(i))) continue;
            return false;
        }
        return drInstance.getLabel().equals(this.getLabel());
    }

    public int hashCode() {
        int result = 42;
        result = result * 31 + this.dyads.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DyadRankingInstance: ");
        builder.append(this.dyads);
        return builder.toString();
    }

    @Override
    public void setDyads(Set<IDyad> dyads) {
        this.dyads = dyads;
    }

    @Override
    public void setRanking(Ranking<IDyad> ranking) {
        this.rankingOverDyads = new Ranking<IDyad>((Collection<IDyad>)ranking);
    }
}

