/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.ranking.dyad.dataset;

import ai.libs.jaicore.ml.ranking.dyad.dataset.ADyadRankingInstance;
import ai.libs.jaicore.ml.ranking.dyad.learner.Dyad;
import ai.libs.jaicore.ml.ranking.label.learner.clusterbased.customdatatypes.Ranking;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import org.api4.java.ai.ml.ranking.IRanking;
import org.api4.java.ai.ml.ranking.dyad.dataset.IDyad;
import org.api4.java.common.math.IVector;

public class SparseDyadRankingInstance
extends ADyadRankingInstance {
    private IVector context;
    private Set<IVector> alternatives;
    private Ranking<IVector> rankedAlternatives;

    public SparseDyadRankingInstance(IVector context, Set<IVector> alternatives) {
        this.context = context;
        this.alternatives = new HashSet<IVector>(alternatives);
        this.rankedAlternatives = new Ranking();
    }

    public SparseDyadRankingInstance(IVector context, List<IVector> alternatives) {
        this.context = context;
        this.alternatives = new HashSet<IVector>(alternatives);
        this.rankedAlternatives = new Ranking<IVector>((Collection<IVector>)alternatives);
    }

    @Override
    public Set<IDyad> getAttributeValue(int position) {
        if (position == 0) {
            return new HashSet<IDyad>(this.alternatives.stream().map(y -> new Dyad(this.context, (IVector)y)).collect(Collectors.toList()));
        }
        throw new IllegalArgumentException("No attribute at position " + position + ".");
    }

    public IRanking<IDyad> getLabel() {
        return new Ranking<IDyad>(this.rankedAlternatives.stream().map(y -> new Dyad(this.context, (IVector)y)).collect(Collectors.toList()));
    }

    public Iterator<IDyad> iterator() {
        return new Iterator<IDyad>(){
            private int index = 0;
            private List<IDyad> dyads = new ArrayList<IDyad>((Collection<IDyad>)SparseDyadRankingInstance.this.getAttributeValue(0));

            @Override
            public boolean hasNext() {
                return this.index < SparseDyadRankingInstance.this.getNumberOfRankedElements();
            }

            @Override
            public IDyad next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.dyads.get(this.index++);
            }
        };
    }

    public IVector getContext() {
        return this.context;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SparseDyadRankingInstance: ");
        builder.append(System.lineSeparator());
        builder.append("Instance: ");
        builder.append(this.context);
        builder.append(System.lineSeparator());
        builder.append("Alternatives: ");
        builder.append(this.alternatives);
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alternatives == null ? 0 : this.alternatives.hashCode());
        result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SparseDyadRankingInstance other = (SparseDyadRankingInstance)obj;
        if (this.alternatives == null ? other.alternatives != null : !this.alternatives.equals(other.alternatives)) {
            return false;
        }
        return !(this.context == null ? other.context != null : !this.context.equals(other.context));
    }

    public int getNumberOfRankedElements() {
        return this.alternatives.size();
    }

    @Override
    public void setDyads(Set<IDyad> dyads) {
        this.assertThatAllContextsAreIdentical(dyads);
        this.context = dyads.iterator().next().getContext();
        this.alternatives = dyads.stream().map(IDyad::getAlternative).collect(Collectors.toSet());
    }

    @Override
    public void setRanking(Ranking<IDyad> ranking) {
        this.assertThatAllContextsAreIdentical(ranking);
    }

    private void assertThatAllContextsAreIdentical(Collection<IDyad> dyads) {
        IDyad anyDyad = dyads.iterator().next();
        boolean allContextsIdentical = dyads.stream().allMatch(d -> d.getContext().equals(anyDyad.getContext()));
        if (!allContextsIdentical) {
            throw new IllegalArgumentException("For a sparse dyad ranking instance, all contexts have to be identical.");
        }
    }
}

