/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.ranking.dyad.learner;

import org.api4.java.ai.ml.ranking.dyad.dataset.IDyad;
import org.api4.java.common.math.IVector;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class Dyad
implements IDyad {
    private IVector context;
    private IVector alternative;

    public Dyad(IVector instance, IVector alternative) {
        this.context = instance;
        this.alternative = alternative;
    }

    public IVector getContext() {
        return this.context;
    }

    public IVector getAlternative() {
        return this.alternative;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Dyad (");
        builder.append("instance (");
        builder.append(this.context);
        builder.append(")");
        builder.append("alternative (");
        builder.append(this.alternative);
        builder.append(")");
        builder.append(")");
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Dyad)) {
            return false;
        }
        Dyad other = (Dyad)o;
        if (this.context != null && other.context != null && this.alternative != null && other.alternative != null && other.context.equals(this.context) && other.alternative.equals(this.alternative)) {
            return this.context.equals(other.context) && this.alternative.equals(other.alternative);
        }
        return this.context == null && other.context == null && this.alternative == null && other.alternative == null;
    }

    public int hashCode() {
        int result = 42;
        result = result * 31 + this.context.hashCode();
        result = result * 31 + this.alternative.hashCode();
        return result;
    }

    public INDArray toVector() {
        INDArray instanceOfDyad = Nd4j.create((double[])this.getContext().asArray());
        INDArray alternativeOfDyad = Nd4j.create((double[])this.getAlternative().asArray());
        return Nd4j.hstack((INDArray[])new INDArray[]{instanceOfDyad, alternativeOfDyad});
    }

    public double[] toDoubleVector() {
        double[] array = new double[this.getContext().length() + this.getAlternative().length()];
        this.getContext().asArray();
        System.arraycopy(array, 0, this.getContext(), 0, this.getContext().length());
        return array;
    }
}

