/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.ranking.dyad.learner.search;

import ai.libs.jaicore.ml.ranking.dyad.learner.algorithm.IDyadRanker;
import ai.libs.jaicore.ml.ranking.dyad.learner.algorithm.PLNetDyadRanker;
import ai.libs.jaicore.ml.ranking.dyad.learner.util.AbstractDyadScaler;
import ai.libs.jaicore.ml.ranking.dyad.learner.util.DyadMinMaxScaler;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.IBestFirstQueueConfiguration;
import ai.libs.jaicore.search.probleminputs.GraphSearchWithSubpathEvaluationsInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ADyadRankedNodeQueueConfig<N>
implements IBestFirstQueueConfiguration<GraphSearchWithSubpathEvaluationsInput<N, String, Double>, N, String, Double> {
    private Logger logger = LoggerFactory.getLogger(ADyadRankedNodeQueueConfig.class);
    protected IDyadRanker ranker;
    protected AbstractDyadScaler scaler;

    public ADyadRankedNodeQueueConfig() throws IOException, ClassNotFoundException {
        this.logger.trace("Load MinMaxScaler");
        FileInputStream fis = new FileInputStream(new File("resources/draco/partial_pipeline_ranking/models/minmax_2500.ser"));
        try (ObjectInputStream ois = new ObjectInputStream(fis);){
            this.scaler = (DyadMinMaxScaler)ois.readObject();
            fis.close();
        }
        this.logger.trace("Load PL-Net Dyad Ranker");
        PLNetDyadRanker plranker = new PLNetDyadRanker();
        plranker.loadModelFromFile("resources/draco/partial_pipeline_ranking/models/ranker_2500.zip");
        this.ranker = plranker;
    }

    public IDyadRanker getRanker() {
        return this.ranker;
    }

    public void setRanker(IDyadRanker ranker) {
        this.ranker = ranker;
    }

    public AbstractDyadScaler getScaler() {
        return this.scaler;
    }

    public void setScaler(AbstractDyadScaler scaler) {
        this.scaler = scaler;
    }
}

