/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.ranking.dyad.learner.util;

import ai.libs.jaicore.ml.ranking.dyad.dataset.DenseDyadRankingInstance;
import ai.libs.jaicore.ml.ranking.dyad.dataset.SparseDyadRankingInstance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.api4.java.ai.ml.ranking.dyad.dataset.IDyad;
import org.api4.java.ai.ml.ranking.dyad.dataset.IDyadRankingDataset;
import org.api4.java.ai.ml.ranking.dyad.dataset.IDyadRankingInstance;
import org.api4.java.common.math.IVector;

public abstract class AbstractDyadScaler
implements Serializable {
    private static final long serialVersionUID = -825893010030419116L;
    protected SummaryStatistics[] statsX;
    protected SummaryStatistics[] statsY;

    public SummaryStatistics[] getStatsX() {
        return this.statsX;
    }

    public SummaryStatistics[] getStatsY() {
        return this.statsY;
    }

    public void fit(IDyadRankingDataset dataset) {
        int i;
        int lengthX = ((IDyad)((IDyadRankingInstance)dataset.get(0)).getLabel().get(0)).getContext().length();
        int lengthY = ((IDyad)((IDyadRankingInstance)dataset.get(0)).getLabel().get(0)).getAlternative().length();
        this.statsX = new SummaryStatistics[lengthX];
        this.statsY = new SummaryStatistics[lengthY];
        for (i = 0; i < lengthX; ++i) {
            this.statsX[i] = new SummaryStatistics();
        }
        for (i = 0; i < lengthY; ++i) {
            this.statsY[i] = new SummaryStatistics();
        }
        for (IDyadRankingInstance instance : dataset) {
            for (IDyad dyad : instance) {
                int i2;
                for (i2 = 0; i2 < lengthX; ++i2) {
                    this.statsX[i2].addValue(dyad.getContext().getValue(i2));
                }
                for (i2 = 0; i2 < lengthY; ++i2) {
                    this.statsY[i2].addValue(dyad.getAlternative().getValue(i2));
                }
            }
        }
    }

    public void transform(IDyadRankingDataset dataset) {
        int lengthX = ((IDyad)((IDyadRankingInstance)dataset.get(0)).getLabel().get(0)).getContext().length();
        int lengthY = ((IDyad)((IDyadRankingInstance)dataset.get(0)).getLabel().get(0)).getAlternative().length();
        if (lengthX != this.statsX.length || lengthY != this.statsY.length) {
            throw new IllegalArgumentException("The scaler was fit to dyads with instances of length " + this.statsX.length + " and alternatives of length " + this.statsY.length + "\n but received instances of length " + lengthX + " and alternatives of length " + lengthY);
        }
        this.transformInstances(dataset);
        this.transformAlternatives(dataset);
    }

    public void transformInstances(IDyadRankingDataset dataset) {
        this.transformInstances(dataset, new ArrayList<Integer>());
    }

    public void transformAlternatives(IDyadRankingDataset dataset) {
        this.transformAlternatives(dataset, new ArrayList<Integer>());
    }

    public abstract void transformInstances(IDyad var1, List<Integer> var2);

    public abstract void transformAlternatives(IDyad var1, List<Integer> var2);

    public abstract void transformInstaceVector(IVector var1, List<Integer> var2);

    public void transformInstances(SparseDyadRankingInstance drInstance, List<Integer> ignoredIndices) {
        this.transformInstaceVector(drInstance.getContext(), ignoredIndices);
    }

    public void transformInstances(IDyadRankingInstance drInstance, List<Integer> ignoredIndices) {
        for (IDyad dyad : drInstance) {
            this.transformInstances(dyad, ignoredIndices);
        }
    }

    public void transformAlternatives(IDyadRankingInstance drInstance, List<Integer> ignoredIndices) {
        for (IDyad dyad : drInstance) {
            this.transformAlternatives(dyad, ignoredIndices);
        }
    }

    public void transformInstances(IDyadRankingDataset dataset, List<Integer> ignoredIndices) {
        for (IDyadRankingInstance instance : dataset) {
            if (instance instanceof SparseDyadRankingInstance) {
                SparseDyadRankingInstance drSparseInstance = (SparseDyadRankingInstance)instance;
                this.transformInstances(drSparseInstance, ignoredIndices);
                continue;
            }
            if (instance instanceof DenseDyadRankingInstance) {
                DenseDyadRankingInstance drDenseInstance = (DenseDyadRankingInstance)instance;
                this.transformInstances(drDenseInstance, ignoredIndices);
                continue;
            }
            throw new IllegalArgumentException("The scalers only support SparseDyadRankingInstance and DyadRankingInstance!");
        }
    }

    public void transformAlternatives(IDyadRankingDataset dataset, List<Integer> ignoredIndices) {
        for (IDyadRankingInstance instance : dataset) {
            this.transformAlternatives(instance, ignoredIndices);
        }
    }

    public void fitTransform(IDyadRankingDataset dataset) {
        this.fit(dataset);
        this.transform(dataset);
    }

    public String getPrettySTDString() {
        if (this.statsX == null || this.statsY == null) {
            throw new IllegalStateException("The scaler must be fit before calling this method!");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Standard deviations for instances: ");
        for (SummaryStatistics stats : this.statsX) {
            builder.append(stats.getStandardDeviation());
            builder.append(", ");
        }
        builder.append(System.lineSeparator());
        builder.append("Standard deviations for alternatives: ");
        for (SummaryStatistics stats : this.statsY) {
            builder.append(stats.getStandardDeviation());
            builder.append(", ");
        }
        builder.append(System.lineSeparator());
        return builder.toString();
    }

    public String getPrettyMeansString() {
        if (this.statsX == null || this.statsY == null) {
            throw new IllegalStateException("The scaler must be fit before calling this method!");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Means for instances: ");
        for (SummaryStatistics stats : this.statsX) {
            builder.append(stats.getMean());
            builder.append(", ");
        }
        builder.append(System.lineSeparator());
        builder.append("Means for alternatives: ");
        for (SummaryStatistics stats : this.statsY) {
            builder.append(stats.getMean());
            builder.append(", ");
        }
        builder.append(System.lineSeparator());
        return builder.toString();
    }
}

