/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.ranking.dyad.learner.util;

import ai.libs.jaicore.ml.ranking.dyad.dataset.DyadRankingDataset;
import ai.libs.jaicore.ml.ranking.dyad.learner.util.AbstractDyadScaler;
import java.text.DecimalFormat;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.api4.java.ai.ml.ranking.dyad.dataset.IDyad;
import org.api4.java.ai.ml.ranking.dyad.dataset.IDyadRankingInstance;
import org.api4.java.common.math.IVector;

public class DyadMinMaxScaler
extends AbstractDyadScaler {
    private static final long serialVersionUID = -1319262573945961139L;

    public void untransform(DyadRankingDataset dataset) {
        int lengthX = ((IDyad)((IDyadRankingInstance)dataset.get(0)).getLabel().get(0)).getContext().length();
        int lengthY = ((IDyad)((IDyadRankingInstance)dataset.get(0)).getLabel().get(0)).getAlternative().length();
        if (lengthX != this.statsX.length || lengthY != this.statsY.length) {
            throw new IllegalArgumentException("The scaler was fit to dyads with instances of length " + this.statsX.length + " and alternatives of length " + this.statsY.length + "\n but received instances of length " + lengthX + " and alternatives of length " + lengthY);
        }
        this.untransformInstances(dataset);
        this.untransformAlternatives(dataset);
    }

    public void untransformInstances(DyadRankingDataset dataset) {
        for (IDyadRankingInstance instance : dataset) {
            for (IDyad dyad : instance) {
                this.untransformInstance(dyad);
            }
        }
    }

    public void untransformInstances(DyadRankingDataset dataset, int decimals) {
        for (IDyadRankingInstance instance : dataset) {
            for (IDyad dyad : instance) {
                this.untransformInstance(dyad, decimals);
            }
        }
    }

    public void untransformInstance(IDyad dyad) {
        int lengthX = dyad.getContext().length();
        if (lengthX != this.statsX.length) {
            throw new IllegalArgumentException("The scaler was fit to instances of length " + this.statsX.length + " but received an instance of length " + lengthX + ".");
        }
        for (int i = 0; i < lengthX; ++i) {
            double value = dyad.getContext().getValue(i);
            value *= this.statsX[i].getMax() - this.statsX[i].getMin();
            dyad.getContext().setValue(i, value += this.statsX[i].getMin());
        }
    }

    public void untransformInstance(IDyad dyad, int decimals) {
        StringBuilder pattern = new StringBuilder();
        pattern.append("#.");
        for (int i = 0; i < decimals; ++i) {
            pattern.append("#");
        }
        int lengthX = dyad.getContext().length();
        if (lengthX != this.statsX.length) {
            throw new IllegalArgumentException("The scaler was fit to instances of length " + this.statsX.length + " but received an instance of length " + lengthX + ".");
        }
        DecimalFormat df = new DecimalFormat(pattern.toString());
        for (int i = 0; i < lengthX; ++i) {
            double value = dyad.getContext().getValue(i);
            value *= this.statsX[i].getMax() - this.statsX[i].getMin();
            dyad.getContext().setValue(i, Double.valueOf(df.format(value += this.statsX[i].getMin())).doubleValue());
        }
    }

    public void untransformAlternatives(DyadRankingDataset dataset) {
        for (IDyadRankingInstance instance : dataset) {
            for (IDyad dyad : instance) {
                this.untransformAlternative(dyad);
            }
        }
    }

    public void untransformAlternatives(DyadRankingDataset dataset, int decimals) {
        for (IDyadRankingInstance instance : dataset) {
            for (IDyad dyad : instance) {
                this.untransformAlternative(dyad, decimals);
            }
        }
    }

    public void untransformAlternative(IDyad dyad) {
        int lengthY = dyad.getAlternative().length();
        if (lengthY != this.statsY.length) {
            throw new IllegalArgumentException("The scaler was fit to alternatives of length " + this.statsY.length + " but received an alternative of length " + lengthY + ".");
        }
        for (int i = 0; i < lengthY; ++i) {
            double value = dyad.getAlternative().getValue(i);
            value *= this.statsY[i].getMax() - this.statsY[i].getMin();
            dyad.getAlternative().setValue(i, value += this.statsY[i].getMin());
        }
    }

    public void untransformAlternative(IDyad dyad, int decimals) {
        StringBuilder pattern = new StringBuilder();
        pattern.append("#.");
        for (int i = 0; i < decimals; ++i) {
            pattern.append("#");
        }
        int lengthY = dyad.getAlternative().length();
        if (lengthY != this.statsY.length) {
            throw new IllegalArgumentException("The scaler was fit to alternatives of length " + this.statsY.length + " but received an alternative of length " + lengthY + ".");
        }
        DecimalFormat df = new DecimalFormat(pattern.toString());
        for (int i = 0; i < lengthY; ++i) {
            double value = dyad.getAlternative().getValue(i);
            value *= this.statsY[i].getMax() - this.statsY[i].getMin();
            dyad.getAlternative().setValue(i, Double.valueOf(df.format(value += this.statsY[i].getMin())).doubleValue());
        }
    }

    public String getPrettyMaximaString() {
        if (this.statsX == null || this.statsY == null) {
            throw new IllegalStateException("The scaler must be fit before calling this method!");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Standard deviations for instances: ");
        for (SummaryStatistics stats : this.statsX) {
            builder.append(stats.getMax());
            builder.append(", ");
        }
        builder.append(System.lineSeparator());
        builder.append("Standard deviations for alternatives: ");
        for (SummaryStatistics stats : this.statsY) {
            builder.append(stats.getMax());
            builder.append(", ");
        }
        builder.append(System.lineSeparator());
        return builder.toString();
    }

    public String getPrettyMinimaString() {
        if (this.statsX == null || this.statsY == null) {
            throw new IllegalStateException("The scaler must be fit before calling this method!");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Means for instances: ");
        for (SummaryStatistics stats : this.statsX) {
            builder.append(stats.getMin());
            builder.append(", ");
        }
        builder.append(System.lineSeparator());
        builder.append("Means for alternatives: ");
        for (SummaryStatistics stats : this.statsY) {
            builder.append(stats.getMin());
            builder.append(", ");
        }
        builder.append(System.lineSeparator());
        return builder.toString();
    }

    @Override
    public void transformInstances(IDyad dyad, List<Integer> ignoredIndices) {
        for (int i = 0; i < dyad.getContext().length(); ++i) {
            double value = dyad.getContext().getValue(i);
            value -= this.statsX[i].getMin();
            if (this.statsX[i].getMax() - this.statsX[i].getMin() != 0.0) {
                value /= this.statsX[i].getMax() - this.statsX[i].getMin();
            }
            dyad.getContext().setValue(i, value);
        }
    }

    @Override
    public void transformAlternatives(IDyad dyad, List<Integer> ignoredIndices) {
        for (int i = 0; i < dyad.getAlternative().length(); ++i) {
            if (ignoredIndices.contains(i)) continue;
            double value = dyad.getAlternative().getValue(i);
            value -= this.statsY[i].getMin();
            if (this.statsY[i].getMax() - this.statsY[i].getMin() != 0.0) {
                value /= this.statsY[i].getMax() - this.statsY[i].getMin();
            }
            dyad.getAlternative().setValue(i, value);
        }
    }

    @Override
    public void transformInstaceVector(IVector vector, List<Integer> ignoredIndices) {
        for (int i = 0; i < vector.length(); ++i) {
            double value = vector.getValue(i);
            value -= this.statsX[i].getMin();
            if (this.statsX[i].getMax() - this.statsX[i].getMin() != 0.0) {
                value /= this.statsX[i].getMax() - this.statsX[i].getMin();
            }
            vector.setValue(i, value);
        }
    }
}

