/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.ranking.loss;

import ai.libs.jaicore.ml.ranking.loss.ARankingPredictionPerformanceMeasure;
import org.api4.java.ai.ml.ranking.IRanking;
import org.api4.java.ai.ml.ranking.loss.IRankingPredictionPerformanceMeasure;

public class KendallsTauDyadRankingLoss
extends ARankingPredictionPerformanceMeasure
implements IRankingPredictionPerformanceMeasure {
    @Override
    public double loss(IRanking<?> expected, IRanking<?> predicted) {
        int dyadRankingLength = expected.size();
        if (dyadRankingLength <= 1) {
            throw new IllegalArgumentException("Dyad rankings must have length greater than 1.");
        }
        int nConc = 0;
        int nDisc = 0;
        for (int predIndex = 0; predIndex < dyadRankingLength - 1; ++predIndex) {
            int i;
            Object predDyad = predicted.get(predIndex);
            int actualIndex = -1;
            for (i = 0; i < dyadRankingLength; ++i) {
                if (!expected.get(i).equals(predDyad)) continue;
                actualIndex = i;
                break;
            }
            for (i = predIndex + 1; i < dyadRankingLength; ++i) {
                if (this.isRankingCorrectForIndex(expected, predicted, dyadRankingLength, actualIndex, i)) {
                    ++nConc;
                    continue;
                }
                ++nDisc;
            }
        }
        return 2.0 * (double)(nConc - nDisc) / (double)(dyadRankingLength * (dyadRankingLength - 1));
    }

    private boolean isRankingCorrectForIndex(IRanking<?> actual, IRanking<?> predicted, int dyadRankingLength, int actualIndex, int i) {
        Object predPairedDyad = predicted.get(i);
        boolean found = false;
        for (int j = actualIndex + 1; j < dyadRankingLength && !found; ++j) {
            if (!actual.get(j).equals(predPairedDyad)) continue;
            found = true;
        }
        return found;
    }
}

