/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.scikitwrapper;

import ai.libs.jaicore.ml.scikitwrapper.AProcessListener;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProcessListener
extends AProcessListener {
    private static final Logger L = LoggerFactory.getLogger(DefaultProcessListener.class);
    protected final boolean verbose;
    private StringBuilder errorSB;
    private StringBuilder defaultSB;

    public DefaultProcessListener(boolean verbose) {
        this.verbose = verbose;
        this.errorSB = new StringBuilder();
        this.defaultSB = new StringBuilder();
    }

    @Override
    public void handleError(String error) {
        this.errorSB.append(error + "\n");
        if (this.verbose) {
            L.error(">>> {}", (Object)error);
        }
    }

    @Override
    public void handleInput(String input) throws IOException, InterruptedException {
        this.defaultSB.append(input + "\n");
        if (this.verbose) {
            L.info(">>> {}", (Object)input);
        }
    }

    public String getErrorOutput() {
        return this.errorSB.toString();
    }

    public String getDefaultOutput() {
        return this.defaultSB.toString();
    }
}

