/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.classification.loss.dataset;

import java.util.List;
import java.util.OptionalDouble;
import java.util.stream.IntStream;
import org.api4.java.ai.ml.core.evaluation.IPredictionAndGroundTruthTable;
import org.api4.java.ai.ml.core.evaluation.supervised.loss.IDeterministicInstancePredictionPerformanceMeasure;
import org.api4.java.ai.ml.core.evaluation.supervised.loss.IDeterministicPredictionPerformanceMeasure;

public abstract class APredictionPerformanceMeasure<E, P>
implements IDeterministicPredictionPerformanceMeasure<E, P> {
    protected void checkConsistency(List<? extends E> expected, List<? extends P> predicted) {
        if (expected.size() != predicted.size()) {
            throw new IllegalArgumentException("The expected and predicted classification lists must be of the same length.");
        }
    }

    public double loss(IPredictionAndGroundTruthTable<? extends E, ? extends P> pairTable) {
        return this.loss(pairTable.getGroundTruthAsList(), pairTable.getPredictionsAsList());
    }

    public double loss(List<? extends E> expected, List<? extends P> predicted) {
        return -this.score(expected, predicted);
    }

    public double score(List<? extends E> expected, List<? extends P> predicted) {
        return -this.loss(expected, predicted);
    }

    public double score(IPredictionAndGroundTruthTable<? extends E, ? extends P> pairTable) {
        return this.score(pairTable.getGroundTruthAsList(), pairTable.getPredictionsAsList());
    }

    protected double averageInstanceWiseLoss(List<? extends E> expected, List<? extends P> predicted, IDeterministicInstancePredictionPerformanceMeasure<P, E> subMeasure) {
        OptionalDouble res = IntStream.range(0, expected.size()).mapToDouble(x -> subMeasure.loss(expected.get(x), predicted.get(x))).average();
        if (res.isPresent()) {
            return res.getAsDouble();
        }
        throw new IllegalStateException("The submeasure could not be aggregated.");
    }

    protected double averageInstanceWiseScore(List<? extends E> expected, List<? extends P> predicted, IDeterministicInstancePredictionPerformanceMeasure<P, E> subMeasure) {
        OptionalDouble res = IntStream.range(0, expected.size()).mapToDouble(x -> subMeasure.score(expected.get(x), predicted.get(x))).average();
        if (res.isPresent()) {
            return res.getAsDouble();
        }
        throw new IllegalStateException("The submeasure could not be aggregated.");
    }
}

