/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.classification.loss.dataset;

import ai.libs.jaicore.ml.classification.loss.dataset.ErrorRate;
import ai.libs.jaicore.ml.classification.loss.dataset.F1Measure;
import ai.libs.jaicore.ml.classification.loss.dataset.FalseNegatives;
import ai.libs.jaicore.ml.classification.loss.dataset.FalsePositives;
import ai.libs.jaicore.ml.classification.loss.dataset.Precision;
import ai.libs.jaicore.ml.classification.loss.dataset.Recall;
import ai.libs.jaicore.ml.classification.loss.dataset.TrueNegatives;
import ai.libs.jaicore.ml.classification.loss.dataset.TruePositives;
import java.util.List;
import org.api4.java.ai.ml.classification.singlelabel.evaluation.ISingleLabelClassification;
import org.api4.java.ai.ml.core.evaluation.IPredictionAndGroundTruthTable;
import org.api4.java.ai.ml.core.evaluation.supervised.loss.IDeterministicPredictionPerformanceMeasure;

public enum EClassificationPerformanceMeasure implements IDeterministicPredictionPerformanceMeasure<Integer, ISingleLabelClassification>
{
    ERRORRATE(new ErrorRate()),
    TRUE_NEGATIVES_WITH_1_POSITIVE(new TrueNegatives(1)),
    TRUE_POSITIVES_WITH_1_POSITIVE(new TruePositives(1)),
    FALSE_NEGATIVES_WITH_1_POSITIVE(new FalseNegatives(1)),
    FALSE_POSITIVES_WITH_1_POSITIVE(new FalsePositives(1)),
    PRECISION_WITH_1_POSITIVE(new Precision(1)),
    RECALL_WITH_1_POSITIVE(new Recall(1)),
    F1_WITH_1_POSITIVE(new F1Measure(1));

    private final IDeterministicPredictionPerformanceMeasure<Integer, ISingleLabelClassification> measure;

    private EClassificationPerformanceMeasure(IDeterministicPredictionPerformanceMeasure<Integer, ISingleLabelClassification> measure) {
        this.measure = measure;
    }

    public double loss(List<? extends Integer> expected, List<? extends ISingleLabelClassification> predicted) {
        return this.measure.loss(expected, predicted);
    }

    public double loss(IPredictionAndGroundTruthTable<? extends Integer, ? extends ISingleLabelClassification> pairTable) {
        return this.measure.loss(pairTable);
    }

    public double score(List<? extends Integer> expected, List<? extends ISingleLabelClassification> predicted) {
        return this.measure.score(expected, predicted);
    }

    public double score(IPredictionAndGroundTruthTable<? extends Integer, ? extends ISingleLabelClassification> pairTable) {
        return this.measure.score(pairTable);
    }
}

