/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.classification.loss.dataset;

import ai.libs.jaicore.basic.metric.ConfusionMetrics;
import ai.libs.jaicore.ml.classification.loss.dataset.ASingleLabelClassificationPerformanceMeasure;
import ai.libs.jaicore.ml.classification.loss.dataset.FalseNegatives;
import ai.libs.jaicore.ml.classification.loss.dataset.FalsePositives;
import ai.libs.jaicore.ml.classification.loss.dataset.TruePositives;
import java.util.List;
import org.api4.java.ai.ml.classification.singlelabel.evaluation.ISingleLabelClassification;

public class FMeasure
extends ASingleLabelClassificationPerformanceMeasure {
    private final double beta;
    private final TruePositives tp;
    private final FalsePositives fp;
    private final FalseNegatives fn;

    public FMeasure(double beta, int positiveClass) {
        this.beta = beta;
        this.tp = new TruePositives(positiveClass);
        this.fp = new FalsePositives(positiveClass);
        this.fn = new FalseNegatives(positiveClass);
    }

    @Override
    public double score(List<? extends Integer> expected, List<? extends ISingleLabelClassification> predicted) {
        if (expected.size() != predicted.size()) {
            throw new IllegalArgumentException("Expected and actual must be of the same length.");
        }
        return ConfusionMetrics.getFMeasure((double)this.beta, (int)((int)this.tp.score(expected, predicted)), (int)((int)this.fp.score(expected, predicted)), (int)((int)this.fn.score(expected, predicted)));
    }
}

