/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.classification.loss.instance;

import ai.libs.jaicore.ml.classification.loss.instance.AInstanceMeasure;
import java.util.Map;
import java.util.stream.IntStream;
import org.api4.java.ai.ml.classification.singlelabel.evaluation.ISingleLabelClassification;

public class CrossEntropyLoss
extends AInstanceMeasure<double[], ISingleLabelClassification> {
    public static final double DEF_EPSILON = 1.0E-15;
    private final double epsilon;

    public CrossEntropyLoss() {
        this(1.0E-15);
    }

    public CrossEntropyLoss(double epsilon) {
        this.epsilon = epsilon;
    }

    @Override
    public double loss(double[] expected, ISingleLabelClassification predicted) {
        Map distributionMap = predicted.getClassDistribution();
        double[] predictedArr = new double[distributionMap.size()];
        IntStream.range(0, distributionMap.size()).forEach(x -> {
            predictedArr[x] = (Double)distributionMap.get(x);
        });
        return -IntStream.range(0, expected.length).mapToDouble(i -> expected[i] * Math.log(this.minMax(predictedArr[i]))).sum();
    }

    private double minMax(double value) {
        return Math.min(1.0 - this.epsilon, Math.max(value, this.epsilon));
    }
}

