/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.classification.multilabel.evaluation.loss.nonadditive;

import ai.libs.jaicore.ml.classification.multilabel.evaluation.loss.AMultiLabelClassificationMeasure;
import ai.libs.jaicore.ml.classification.multilabel.evaluation.loss.nonadditive.choquistic.IMassFunction;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.api4.java.ai.ml.classification.multilabel.evaluation.IMultiLabelClassification;

public class ChoquisticRelevanceLoss
extends AMultiLabelClassificationMeasure {
    private final IMassFunction measure;

    public ChoquisticRelevanceLoss(IMassFunction measure) {
        this.measure = measure;
    }

    public ChoquisticRelevanceLoss(double threshold, IMassFunction measure) {
        super(threshold);
        this.measure = measure;
    }

    private double fcrit(int expected, double predicted) {
        return 1.0 - Math.abs(predicted - (double)expected);
    }

    private double instanceLoss(int[] expected, double[] predicted) {
        double sum = 0.0;
        List listOfCis = IntStream.range(0, expected.length).mapToObj(i -> this.fcrit(expected[i], predicted[i])).collect(Collectors.toList());
        listOfCis.add(0.0);
        Collections.sort(listOfCis);
        for (int i2 = 1; i2 < listOfCis.size(); ++i2) {
            sum += ((Double)listOfCis.get(i2) - (Double)listOfCis.get(i2 - 1)) * this.measure.mu(IntStream.range(i2, listOfCis.size()).mapToObj(listOfCis::get).collect(Collectors.toList()), expected.length);
        }
        return sum;
    }

    @Override
    public double loss(List<? extends int[]> expected, List<? extends IMultiLabelClassification> predicted) {
        this.checkConsistency(expected, predicted);
        DescriptiveStatistics stats = new DescriptiveStatistics();
        for (int i = 0; i < expected.size(); ++i) {
            stats.addValue(this.instanceLoss(expected.get(i), predicted.get(i).getPrediction()));
        }
        return stats.getMean();
    }

    @Override
    public double score(List<? extends int[]> expected, List<? extends IMultiLabelClassification> predicted) {
        return 1.0 - this.loss(expected, predicted);
    }
}

