/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.classification.singlelabel.timeseries.dataset;

import ai.libs.jaicore.ml.classification.singlelabel.timeseries.dataset.ITimeSeriesInstance;
import ai.libs.jaicore.ml.classification.singlelabel.timeseries.model.INDArrayTimeseries;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class TimeSeriesInstance
implements ITimeSeriesInstance {
    private List<INDArrayTimeseries> attributeValues;
    private Object label;

    public TimeSeriesInstance(INDArrayTimeseries[] attributeValues, Object targetValue) {
        this(Arrays.asList(attributeValues), targetValue);
    }

    public TimeSeriesInstance(List<INDArrayTimeseries> attributeValues, Object targetValue) {
        this.attributeValues = attributeValues;
        this.label = targetValue;
    }

    public INDArrayTimeseries getAttributeValue(int pos) {
        return this.attributeValues.get(pos);
    }

    public Object getLabel() {
        return this.label;
    }

    @Override
    public Iterator<INDArrayTimeseries> iterator() {
        return this.attributeValues.iterator();
    }

    public double[] getPoint() {
        double[] point = new double[this.attributeValues.stream().mapToInt(INDArrayTimeseries::length).sum()];
        int i = 0;
        for (INDArrayTimeseries series : this.attributeValues) {
            double[] seriesPoint = series.getPoint();
            for (int j = 0; j < seriesPoint.length; ++j) {
                point[i++] = seriesPoint[j];
            }
        }
        return point;
    }

    public Object[] getAttributes() {
        return this.attributeValues.toArray();
    }

    public void removeColumn(int columnPos) {
        if (columnPos >= this.attributeValues.size() || columnPos < 0) {
            throw new IllegalArgumentException("The index is not valid.");
        }
        this.attributeValues.remove(columnPos);
    }

    public double getPointValue(int pos) {
        throw new UnsupportedOperationException("This operation is not supported.");
    }

    public void setLabel(Object label) {
        this.label = label;
    }

    public void setAttributeValue(int pos, Object value) {
        if (!(value instanceof INDArrayTimeseries)) {
            throw new IllegalArgumentException("The given value is no timeseries.");
        }
        this.attributeValues.add((INDArrayTimeseries)value);
    }

    public boolean isLabelPresent() {
        return this.label != null;
    }
}

