/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.classification.singlelabel.timeseries.learner;

import ai.libs.jaicore.ml.classification.singlelabel.timeseries.dataset.TimeSeriesDataset2;
import ai.libs.jaicore.ml.classification.singlelabel.timeseries.learner.ASimplifiedTSCLearningAlgorithm;
import ai.libs.jaicore.ml.classification.singlelabel.timeseries.util.ClassMapper;
import java.util.List;
import org.api4.java.ai.ml.core.exception.PredictionException;
import org.api4.java.ai.ml.core.exception.TrainingException;

public abstract class ASimplifiedTSClassifier<T> {
    protected ClassMapper classMapper;
    protected boolean trained;

    public abstract T predict(double[] var1) throws PredictionException;

    public T predict(List<double[]> multivInstance) throws PredictionException {
        throw new PredictionException("Can't predict on multivariate data yet.");
    }

    public abstract List<T> predict(TimeSeriesDataset2 var1) throws PredictionException;

    public abstract <U extends ASimplifiedTSClassifier<T>> ASimplifiedTSCLearningAlgorithm<T, U> getLearningAlgorithm(TimeSeriesDataset2 var1);

    public final void train(TimeSeriesDataset2 dataset) throws TrainingException {
        ASimplifiedTSCLearningAlgorithm algorithm = this.getLearningAlgorithm(dataset);
        try {
            algorithm.call();
            this.trained = true;
        }
        catch (Exception e) {
            throw new TrainingException("Could not train model " + this.getClass().getSimpleName(), (Throwable)e);
        }
    }

    public ClassMapper getClassMapper() {
        return this.classMapper;
    }

    public void setClassMapper(ClassMapper classMapper) {
        this.classMapper = classMapper;
    }

    public boolean isTrained() {
        return this.trained;
    }

    protected double[][] checkWhetherPredictionIsPossible(TimeSeriesDataset2 dataset) throws PredictionException {
        if (!this.isTrained()) {
            throw new PredictionException("Model has not been built before!");
        }
        if (dataset == null || dataset.isEmpty()) {
            throw new IllegalArgumentException("Dataset to be predicted must not be null or empty!");
        }
        double[][] testInstances = dataset.getValuesOrNull(0);
        if (testInstances == null) {
            throw new PredictionException("Can't predict on empty dataset.");
        }
        return testInstances;
    }
}

