/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.classification.singlelabel.timeseries.learner.neighbors;

import ai.libs.jaicore.basic.IOwnerBasedAlgorithmConfig;
import ai.libs.jaicore.ml.classification.singlelabel.timeseries.dataset.TimeSeriesDataset2;
import ai.libs.jaicore.ml.classification.singlelabel.timeseries.learner.ASimplifiedTSCLearningAlgorithm;
import ai.libs.jaicore.ml.classification.singlelabel.timeseries.learner.neighbors.NearestNeighborClassifier;
import org.api4.java.algorithm.events.IAlgorithmEvent;
import org.api4.java.algorithm.exceptions.AlgorithmException;

public class NearestNeighborLearningAlgorithm
extends ASimplifiedTSCLearningAlgorithm<Integer, NearestNeighborClassifier> {
    protected NearestNeighborLearningAlgorithm(IOwnerBasedAlgorithmConfig config, NearestNeighborClassifier classifier, TimeSeriesDataset2 input) {
        super(config, classifier, input);
    }

    public NearestNeighborClassifier call() throws AlgorithmException {
        TimeSeriesDataset2 dataset = (TimeSeriesDataset2)this.getInput();
        if (dataset == null) {
            throw new AlgorithmException("No input data set.");
        }
        if (dataset.isMultivariate()) {
            throw new UnsupportedOperationException("Multivariate datasets are not supported.");
        }
        double[][] values = dataset.getValuesOrNull(0);
        if (values == null) {
            throw new AlgorithmException("Empty input data set.");
        }
        int[] targets = dataset.getTargets();
        if (targets == null) {
            throw new AlgorithmException("Empty targets.");
        }
        NearestNeighborClassifier model = (NearestNeighborClassifier)this.getClassifier();
        model.setValues(values);
        model.setTimestamps(dataset.getTimestampsOrNull(0));
        model.setTargets(targets);
        return model;
    }

    @Override
    public IAlgorithmEvent nextWithException() {
        throw new UnsupportedOperationException();
    }
}

