/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.classification.singlelabel.timeseries.shapelets.search;

import ai.libs.jaicore.ml.classification.singlelabel.timeseries.shapelets.Shapelet;
import ai.libs.jaicore.ml.classification.singlelabel.timeseries.shapelets.search.AMinimumDistanceSearchStrategy;
import ai.libs.jaicore.ml.classification.singlelabel.timeseries.util.MathUtil;
import ai.libs.jaicore.ml.classification.singlelabel.timeseries.util.TimeSeriesUtil;

public class ExhaustiveMinimumDistanceSearchStrategy
extends AMinimumDistanceSearchStrategy {
    public ExhaustiveMinimumDistanceSearchStrategy(boolean useBiasCorrection) {
        super(useBiasCorrection);
    }

    @Override
    public double findMinimumDistance(Shapelet shapelet, double[] timeSeries) {
        int l = shapelet.getLength();
        int n = timeSeries.length;
        double min = Double.MAX_VALUE;
        double[] normalizedShapeletData = shapelet.getData();
        for (int i = 0; i <= n - l; ++i) {
            double tmpED = MathUtil.singleSquaredEuclideanDistance(normalizedShapeletData, TimeSeriesUtil.zNormalize(TimeSeriesUtil.getInterval(timeSeries, i, i + l), this.useBiasCorrection));
            if (!(tmpED < min)) continue;
            min = tmpED;
        }
        return min / (double)l;
    }
}

