/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.classification.singlelabel.timeseries.util;

import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.ml.classification.singlelabel.timeseries.dataset.TimeSeriesDataset2;
import ai.libs.jaicore.ml.classification.singlelabel.timeseries.exception.TimeSeriesLoadingException;
import ai.libs.jaicore.ml.classification.singlelabel.timeseries.util.ClassMapper;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplifiedTimeSeriesLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimplifiedTimeSeriesLoader.class);
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final String ARFF_ATTRIBUTE_PREFIX = "@attribute";
    private static final String ARFF_VALUE_DELIMITER = ",";
    private static final String ARFF_DATA_FLAG = "@data";

    private SimplifiedTimeSeriesLoader() {
    }

    public static Pair<TimeSeriesDataset2, ClassMapper> loadArff(File arffFile) throws TimeSeriesLoadingException {
        if (arffFile == null) {
            throw new IllegalArgumentException("Parameter 'arffFile' must not be null!");
        }
        Object[] tsTargetClassNames = SimplifiedTimeSeriesLoader.loadTimeSeriesWithTargetFromArffFile(arffFile);
        ArrayList<double[][]> matrices = new ArrayList<double[][]>();
        matrices.add((double[][])tsTargetClassNames[0]);
        ClassMapper cm = null;
        if (tsTargetClassNames[2] != null) {
            cm = new ClassMapper((List)tsTargetClassNames[2]);
        }
        return new Pair((Object)new TimeSeriesDataset2(matrices, new ArrayList<double[][]>(), (int[])tsTargetClassNames[1]), (Object)cm);
    }

    public static Pair<TimeSeriesDataset2, ClassMapper> loadArffs(File ... arffFiles) throws TimeSeriesLoadingException {
        if (arffFiles == null) {
            throw new IllegalArgumentException("Parameter 'arffFiles' must not be null!");
        }
        ArrayList<double[][]> matrices = new ArrayList<double[][]>();
        int[] target = null;
        List classNames = null;
        for (File arffFile : arffFiles) {
            Object[] tsTargetClassNames = SimplifiedTimeSeriesLoader.loadTimeSeriesWithTargetFromArffFile(arffFile);
            if (classNames == null && tsTargetClassNames[2] != null) {
                classNames = (List)tsTargetClassNames[2];
            } else {
                List furtherClassNames = (List)tsTargetClassNames[2];
                if (classNames != null && furtherClassNames == null || furtherClassNames != null && !furtherClassNames.equals(classNames)) {
                    throw new TimeSeriesLoadingException("Could not load multivariate time series with different targets. Target values have to be stored in each time series arff file and must be equal!");
                }
            }
            if (target == null) {
                target = (int[])tsTargetClassNames[1];
            } else {
                int[] furtherTarget = (int[])tsTargetClassNames[1];
                if (furtherTarget == null || target.length != furtherTarget.length || !Arrays.equals(target, furtherTarget)) {
                    throw new TimeSeriesLoadingException("Could not load multivariate time series with different targets. Target values have to be stored in each time series arff file and must be equal!");
                }
            }
            if (!matrices.isEmpty() && ((double[][])tsTargetClassNames[0]).length != ((double[][])matrices.get(0)).length) {
                throw new TimeSeriesLoadingException("All time series must have the same first dimensionality (number of instances).");
            }
            matrices.add((double[][])tsTargetClassNames[0]);
        }
        ClassMapper cm = null;
        if (classNames != null) {
            cm = new ClassMapper(classNames);
        }
        return new Pair((Object)new TimeSeriesDataset2(matrices, new ArrayList<double[][]>(), target), (Object)cm);
    }

    private static Object[] loadTimeSeriesWithTargetFromArffFile(File arffFile) throws TimeSeriesLoadingException {
        Object[] objectArray;
        double[][] matrix = null;
        int[] targetMatrix = null;
        int numEmptyDataRows = 0;
        List<String> targetValues = null;
        boolean stringAttributes = false;
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(arffFile), StandardCharsets.UTF_8));
        try {
            String line;
            int attributeCount = 0;
            int lineCounter = 0;
            int numInstances = 0;
            int fileLinesCount = SimplifiedTimeSeriesLoader.countFileLines(arffFile);
            boolean targetSet = false;
            boolean readData = false;
            String lastLine = "";
            while ((line = br.readLine()) != null) {
                if (!readData) {
                    ++lineCounter;
                    if (!targetSet && line.equals("") && lastLine.startsWith(ARFF_ATTRIBUTE_PREFIX)) {
                        String targetString = lastLine.substring(lastLine.indexOf(123) + 1, lastLine.length() - 1);
                        targetValues = Arrays.asList(targetString.split(ARFF_VALUE_DELIMITER));
                        if (!SetUtil.doesStringCollectionOnlyContainNumbers(targetValues)) {
                            stringAttributes = true;
                        }
                        targetSet = true;
                    }
                    if (line.startsWith(ARFF_ATTRIBUTE_PREFIX)) {
                        ++attributeCount;
                    }
                    if (line.startsWith(ARFF_DATA_FLAG)) {
                        readData = true;
                        numInstances = fileLinesCount - lineCounter + 1;
                        matrix = new double[numInstances][targetSet ? attributeCount - 1 : attributeCount];
                        targetMatrix = new int[numInstances];
                        lineCounter = 0;
                        if (!targetSet) {
                            LOGGER.warn("No target has been set before reading data.");
                        }
                    }
                } else {
                    if (!line.equals("")) {
                        String[] values = line.split(ARFF_VALUE_DELIMITER);
                        double[] dValues = new double[targetSet ? values.length - 1 : values.length];
                        for (int i = 0; i < values.length - 1; ++i) {
                            dValues[i] = Double.parseDouble(values[i]);
                        }
                        matrix[lineCounter] = dValues;
                        if (targetSet) {
                            targetMatrix[lineCounter] = targetValues.indexOf(values[values.length - 1]);
                        }
                    }
                    ++lineCounter;
                }
                lastLine = line;
            }
            numEmptyDataRows = numInstances - lineCounter;
            if (matrix == null) {
                throw new IllegalStateException("Matrix is null, which it should not be at this point!");
            }
            if (numEmptyDataRows > 0) {
                int endIndex = matrix.length - numEmptyDataRows;
                matrix = SimplifiedTimeSeriesLoader.getInterval(matrix, 0, endIndex);
                targetMatrix = SimplifiedTimeSeriesLoader.getInterval(targetMatrix, 0, endIndex);
            }
            Object[] result = new Object[]{matrix, targetMatrix, stringAttributes ? targetValues : null};
            objectArray = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (UnsupportedEncodingException e) {
                throw new TimeSeriesLoadingException("Could not load time series dataset due to unsupported encoding.", e);
            }
            catch (FileNotFoundException e) {
                throw new TimeSeriesLoadingException(String.format("Could not locate time series dataset file '%s'.", arffFile.getPath()), e);
            }
            catch (IOException e) {
                throw new TimeSeriesLoadingException("Could not load time series dataset due to IOException.", e);
            }
        }
        br.close();
        return objectArray;
    }

    private static double[][] getInterval(double[][] matrix, int begin, int end) {
        if (begin < 0 || begin > matrix.length - 1) {
            throw new IllegalArgumentException("The begin index must be valid!");
        }
        if (end < 1 || end > matrix.length) {
            throw new IllegalArgumentException("The end index must be valid!");
        }
        double[][] result = new double[end - begin][];
        for (int i = 0; i < end - begin; ++i) {
            result[i] = matrix[i + begin];
        }
        return result;
    }

    private static int[] getInterval(int[] array, int begin, int end) {
        if (begin < 0 || begin > array.length - 1) {
            throw new IllegalArgumentException("The begin index must be valid!");
        }
        if (end < 1 || end > array.length) {
            throw new IllegalArgumentException("The end index must be valid!");
        }
        int[] result = new int[end - begin];
        for (int i = 0; i < end - begin; ++i) {
            result[i] = array[i + begin];
        }
        return result;
    }

    public static int countFileLines(File file) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            int i;
            byte[] c = new byte[1024];
            int readChars = ((InputStream)is).read(c);
            if (readChars == -1) {
                int n = 0;
                return n;
            }
            int count = 0;
            while (readChars == 1024) {
                for (i = 0; i < 1024; ++i) {
                    if (c[i] != 10) continue;
                    ++count;
                }
                readChars = ((InputStream)is).read(c);
            }
            while (readChars != -1) {
                for (i = 0; i < readChars; ++i) {
                    if (c[i] != 10) continue;
                    ++count;
                }
                readChars = ((InputStream)is).read(c);
            }
            int n = count == 0 ? 1 : count;
            return n;
        }
    }
}

