/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset;

import java.util.ArrayList;
import java.util.Optional;
import org.api4.java.ai.ml.core.dataset.schema.ILabeledInstanceSchema;
import org.api4.java.ai.ml.core.dataset.schema.attribute.IAttribute;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledDataset;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledInstance;

public abstract class ADataset<I extends ILabeledInstance>
extends ArrayList<I>
implements ILabeledDataset<I> {
    private static final long serialVersionUID = 1158266286156653852L;
    private transient ILabeledInstanceSchema schema;

    protected ADataset(ILabeledInstanceSchema schema) {
        this.schema = schema;
    }

    public ILabeledInstanceSchema getInstanceSchema() {
        return this.schema;
    }

    public void removeColumn(String columnName) {
        Optional<IAttribute> att = this.schema.getAttributeList().stream().filter(x -> x.getName().equals(columnName)).findFirst();
        if (!att.isPresent()) {
            throw new IllegalArgumentException("There is no such attribute with name " + columnName + " to remove.");
        }
        this.removeColumn(this.schema.getAttributeList().indexOf(att.get()));
    }

    public void removeColumn(IAttribute attribute) {
        int index = this.schema.getAttributeList().indexOf(attribute);
        if (index < 0) {
            throw new IllegalArgumentException("There is no such attribute with name " + attribute.getName() + " to remove.");
        }
        this.removeColumn(index);
    }

    public Object[][] getFeatureMatrix() {
        Object[][] featureMatrix = new Object[this.size()][];
        for (int i = 0; i < this.size(); ++i) {
            featureMatrix[i] = ((ILabeledInstance)this.get(i)).getAttributes();
        }
        return featureMatrix;
    }

    public Object[] getLabelVector() {
        return this.stream().map(ILabeledInstance::getLabel).toArray();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ADataset other = (ADataset)obj;
        return !(this.schema == null ? other.schema != null : !this.schema.equals(other.schema));
    }
}

