/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset;

import ai.libs.jaicore.ml.core.dataset.AInstance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DenseInstance
extends AInstance {
    private List<Object> attributes;

    public DenseInstance(Object[] attributes, Object label) {
        this(new ArrayList<Object>(Arrays.asList(attributes)), label);
    }

    public DenseInstance(List<Object> attributes, Object label) {
        super(label);
        this.attributes = attributes;
    }

    public Object getAttributeValue(int pos) {
        return this.attributes.get(pos);
    }

    public void setAttributeValue(int pos, Object value) {
        this.attributes.remove(pos);
        this.attributes.add(pos, value);
    }

    public Object[] getAttributes() {
        return this.attributes.toArray();
    }

    public double[] getPoint() {
        int n = this.attributes.size();
        double[] point = new double[n];
        for (int i = 0; i < n; ++i) {
            Object val = this.attributes.get(i);
            if (val == null) {
                val = 0;
            }
            if (val instanceof Boolean) {
                val = (Boolean)val != false ? 1.0 : 0.0;
            }
            if (!(val instanceof Number)) {
                throw new UnsupportedOperationException("The given instance cannot be cast to a point, because it has a non-numeric value: " + this.attributes);
            }
            if (val instanceof Integer) {
                val = (double)((Integer)val).intValue();
            }
            if (val instanceof Long) {
                val = (double)((Long)val).longValue();
            }
            if (val instanceof Float) {
                val = (double)((Float)val).floatValue();
            }
            point[i] = (Double)val;
        }
        return point;
    }

    public double getPointValue(int pos) {
        return this.getPoint()[pos];
    }

    public void removeColumn(int columnPos) {
        this.attributes.remove(columnPos);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DenseInstance other = (DenseInstance)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes));
    }

    public String toString() {
        return Arrays.toString(this.getAttributes()) + "->" + this.getLabel();
    }
}

