/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset;

import ai.libs.jaicore.ml.core.dataset.AInstance;
import java.util.Map;
import java.util.stream.IntStream;

public class SparseInstance
extends AInstance {
    public static final ENullElement DEF_NULL_ELEMENT = ENullElement.ZERO;
    private ENullElement nullElement;
    private Map<Integer, Object> attributeMap;
    private int numAttributes;

    public SparseInstance(int numAttributes, Map<Integer, Object> attributes, Object label) {
        super(label);
        this.numAttributes = numAttributes;
        this.attributeMap = attributes;
    }

    public Object getAttributeValue(int pos) {
        if (this.attributeMap.containsKey(pos)) {
            return this.attributeMap.get(pos);
        }
        if (this.nullElement != null) {
            switch (this.nullElement) {
                case UNKNOWN: {
                    return "?";
                }
                case ZERO: {
                    return 0;
                }
            }
            throw new UnsupportedOperationException("The use of the specified null element is not defined.");
        }
        return null;
    }

    public Object[] getAttributes() {
        return IntStream.range(0, this.numAttributes).mapToObj(this::getAttributeValue).toArray();
    }

    public double[] getPoint() {
        double[] point = new double[this.numAttributes];
        for (int i = 0; i < this.numAttributes; ++i) {
            point[i] = this.getPointValue(i);
        }
        return point;
    }

    public double getPointValue(int pos) {
        return this.attributeMap.containsKey(pos) ? (Double)this.attributeMap.get(pos) : 0.0;
    }

    public void setAttributeValue(int pos, Object value) {
        if (this.nullElement == ENullElement.ZERO && value.equals(0) || this.nullElement == ENullElement.UNKNOWN && value.equals("?")) {
            return;
        }
        this.attributeMap.put(pos, value);
    }

    public Map<Integer, Object> getAttributeMap() {
        return this.attributeMap;
    }

    public void removeColumn(int columnPos) {
        this.attributeMap.remove(columnPos);
        --this.numAttributes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributeMap == null ? 0 : this.attributeMap.hashCode());
        result = 31 * result + (this.nullElement == null ? 0 : this.nullElement.hashCode());
        result = 31 * result + this.numAttributes;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SparseInstance other = (SparseInstance)obj;
        if (this.attributeMap == null ? other.attributeMap != null : !this.attributeMap.equals(other.attributeMap)) {
            return false;
        }
        if (this.nullElement != other.nullElement) {
            return false;
        }
        return this.numAttributes == other.numAttributes;
    }

    public String toString() {
        return "SparseInstance [nullElement=" + (Object)((Object)this.nullElement) + ", attributeMap=" + this.attributeMap + ", numAttributes=" + this.numAttributes + "]";
    }

    public static enum ENullElement {
        UNKNOWN,
        ZERO;

    }
}

