/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.schema;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.api4.java.ai.ml.core.dataset.IDataset;
import org.api4.java.ai.ml.core.dataset.IInstance;
import org.api4.java.ai.ml.core.dataset.schema.attribute.IAttribute;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledDataset;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetPropertyComputer {
    private static final Logger LOG = LoggerFactory.getLogger(DatasetPropertyComputer.class);

    private DatasetPropertyComputer() {
    }

    public static Map<Integer, Set<Object>> computeAttributeValues(IDataset<?> dataset) {
        ArrayList<Integer> allAttributeIndices = new ArrayList<Integer>();
        int n = dataset.getNumAttributes();
        for (int i = 0; i < n; ++i) {
            allAttributeIndices.add(i);
        }
        return DatasetPropertyComputer.computeAttributeValues(dataset, allAttributeIndices, 1);
    }

    public static Map<Integer, Set<Object>> computeAttributeValues(IDataset<?> dataset, List<Integer> pAttributeIndices, int numCPUs) {
        int attributeIndex;
        List<Integer> attributeIndices;
        LOG.info("computeAttributeValues(): enter");
        HashMap<Integer, Set<Object>> attributeValues = new HashMap<Integer, Set<Object>>();
        int targetIndex = -1;
        if (dataset instanceof ILabeledDataset) {
            targetIndex = dataset.getNumAttributes();
            if (pAttributeIndices == null || pAttributeIndices.isEmpty()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info(String.format("No attribute indices provided. Working with target attribute only (index: %d", targetIndex));
                }
                attributeIndices = Collections.singletonList(targetIndex);
            } else {
                attributeIndices = new ArrayList<Integer>(pAttributeIndices);
                attributeIndices.add(targetIndex);
            }
        } else {
            attributeIndices = new ArrayList<Integer>(pAttributeIndices);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Computing attribute values for attribute indices {}", attributeIndices);
        }
        Iterator<Object> iterator = attributeIndices.iterator();
        while (iterator.hasNext()) {
            attributeIndex = (Integer)iterator.next();
            if (attributeIndex <= dataset.getNumAttributes()) continue;
            throw new IndexOutOfBoundsException(String.format("Attribute index %d is out of bounds for the delivered data set!", attributeIndex));
        }
        iterator = attributeIndices.iterator();
        while (iterator.hasNext()) {
            attributeIndex = (Integer)iterator.next();
            attributeValues.put(attributeIndex, new HashSet());
        }
        ExecutorService threadPool = Executors.newFixedThreadPool(numCPUs);
        ArrayList<Future<Map<Integer, Set<Object>>>> futures = new ArrayList<Future<Map<Integer, Set<Object>>>>();
        if (LOG.isInfoEnabled()) {
            LOG.info(String.format("Starting %d threads for computation..", numCPUs));
        }
        int listSize = dataset.size() / numCPUs;
        for (List list : Lists.partition(dataset, (int)listSize)) {
            futures.add(threadPool.submit(new ListProcessor(list, new HashSet<Integer>(attributeIndices), dataset)));
        }
        threadPool.shutdown();
        for (Future future : futures) {
            try {
                Map localAttributeValues = (Map)future.get();
                for (Map.Entry entry : attributeValues.entrySet()) {
                    IAttribute att = (Integer)entry.getKey() == targetIndex ? ((ILabeledDataset)dataset).getLabelAttribute() : dataset.getAttribute(((Integer)entry.getKey()).intValue());
                    for (Object o : (Set)entry.getValue()) {
                        if (att.isValidValue(o)) continue;
                        throw new IllegalStateException("Collecting invalid value " + o + " for attribute " + att + ". Valid values: " + att.getStringDescriptionOfDomain());
                    }
                    ((Set)attributeValues.get(entry.getKey())).addAll((Collection)localAttributeValues.get(entry.getKey()));
                }
            }
            catch (ExecutionException e) {
                LOG.error("Exception while waiting for future to complete..", (Throwable)e);
            }
            catch (InterruptedException e) {
                LOG.error("Thread has been interrupted");
                Thread.currentThread().interrupt();
            }
        }
        return attributeValues;
    }

    static class ListProcessor<D extends IDataset<?>>
    implements Callable<Map<Integer, Set<Object>>> {
        private List<? extends IInstance> list;
        private Set<Integer> attributeIndices;
        private D dataset;

        public ListProcessor(List<? extends IInstance> list, Set<Integer> attributeIndices, D dataset) {
            this.list = list;
            this.attributeIndices = attributeIndices;
            this.dataset = dataset;
        }

        @Override
        public Map<Integer, Set<Object>> call() {
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("Starting computation on local sublist of length %d", this.list.size()));
            }
            HashMap<Integer, Set<Object>> attributeValues = new HashMap<Integer, Set<Object>>();
            for (int n : this.attributeIndices) {
                attributeValues.put(n, new HashSet());
            }
            for (IInstance iInstance : this.list) {
                for (int attributeIndex : this.attributeIndices) {
                    if (attributeIndex == this.dataset.getNumAttributes()) {
                        Object label = ((ILabeledInstance)iInstance).getLabel();
                        if (label == null) continue;
                        ((Set)attributeValues.get(attributeIndex)).add(label);
                        continue;
                    }
                    Object value = iInstance.getAttributeValue(attributeIndex);
                    if (value == null) continue;
                    ((Set)attributeValues.get(attributeIndex)).add(value);
                }
            }
            LOG.info("Finished local computation");
            return attributeValues;
        }
    }
}

