/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.schema.attribute;

import ai.libs.jaicore.ml.core.dataset.schema.attribute.AAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.api4.java.ai.ml.core.dataset.schema.attribute.IAttributeValue;

public abstract class AGenericObjectAttribute<O>
extends AAttribute {
    private static final long serialVersionUID = 614829108498630281L;
    private transient Map<O, Double> objectToDoubleMap = new HashMap<O, Double>();
    private transient Map<Double, O> doubleToObjectMap = new HashMap<Double, O>();
    private AtomicInteger objectCounter = new AtomicInteger(1);

    protected AGenericObjectAttribute(String name) {
        super(name);
    }

    public double encodeValue(Object attributeValue) {
        if (!this.isValidValue(attributeValue)) {
            throw new IllegalArgumentException("No valid attribute value");
        }
        O value = this.getValueAsTypeInstance(attributeValue);
        if (!this.objectToDoubleMap.containsKey(attributeValue)) {
            double encodedValue = this.objectCounter.getAndIncrement();
            this.objectToDoubleMap.put(value, encodedValue);
            this.doubleToObjectMap.put(encodedValue, value);
            return encodedValue;
        }
        return this.objectToDoubleMap.get(value);
    }

    public O decodeValue(double encodedAttributeValue) {
        return this.doubleToObjectMap.get(encodedAttributeValue);
    }

    public IAttributeValue getAsAttributeValue(double encodedAttributeValue) {
        return this.getAsAttributeValue(this.doubleToObjectMap.get(encodedAttributeValue));
    }

    protected abstract O getValueAsTypeInstance(Object var1);

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.doubleToObjectMap == null ? 0 : this.doubleToObjectMap.hashCode());
        result = 31 * result + (this.objectCounter == null ? 0 : this.objectCounter.hashCode());
        result = 31 * result + (this.objectToDoubleMap == null ? 0 : this.objectToDoubleMap.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AGenericObjectAttribute other = (AGenericObjectAttribute)obj;
        if (this.doubleToObjectMap == null ? other.doubleToObjectMap != null : !this.doubleToObjectMap.equals(other.doubleToObjectMap)) {
            return false;
        }
        if (this.objectCounter == null ? other.objectCounter != null : this.objectCounter.get() != other.objectCounter.get()) {
            return false;
        }
        return !(this.objectToDoubleMap == null ? other.objectToDoubleMap != null : !this.objectToDoubleMap.equals(other.objectToDoubleMap));
    }
}

