/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.schema.attribute;

import ai.libs.jaicore.math.linearalgebra.DenseDoubleVector;
import ai.libs.jaicore.ml.core.dataset.schema.attribute.ARankingAttribute;
import ai.libs.jaicore.ml.core.dataset.schema.attribute.DyadRankingAttributeValue;
import ai.libs.jaicore.ml.ranking.dyad.learner.Dyad;
import ai.libs.jaicore.ml.ranking.label.learner.clusterbased.customdatatypes.Ranking;
import java.util.Arrays;
import org.api4.java.ai.ml.core.dataset.schema.attribute.IRankingAttributeValue;
import org.api4.java.ai.ml.ranking.IRanking;
import org.api4.java.ai.ml.ranking.dyad.dataset.IDyad;
import org.api4.java.common.math.IVector;

public class DyadRankingAttribute
extends ARankingAttribute<IDyad> {
    private static final long serialVersionUID = -7427433693910952078L;

    public DyadRankingAttribute(String name) {
        super(name);
    }

    public boolean isValidValue(Object value) {
        if (value instanceof IRanking) {
            return ((IRanking)value).get(0) instanceof IDyad;
        }
        return value instanceof DyadRankingAttributeValue;
    }

    public String getStringDescriptionOfDomain() {
        return "[DR] " + this.getName();
    }

    public IRankingAttributeValue<IDyad> getAsAttributeValue(Object object) {
        if (this.isValidValue(object)) {
            if (object instanceof DyadRankingAttributeValue) {
                return new DyadRankingAttributeValue(this, ((DyadRankingAttributeValue)object).getValue());
            }
            return new DyadRankingAttributeValue(this, (IRanking<IDyad>)((IRanking)object));
        }
        throw new IllegalArgumentException("No valid value for this attribute");
    }

    @Override
    protected IRanking<IDyad> getValueAsTypeInstance(Object object) {
        if (this.isValidValue(object)) {
            if (object instanceof DyadRankingAttributeValue) {
                return ((DyadRankingAttributeValue)object).getValue();
            }
            return (IRanking)object;
        }
        throw new IllegalArgumentException("No valid value for this attribute");
    }

    public double toDouble(Object object) {
        throw new UnsupportedOperationException("Not yet implemented in DyadRankingAttribute");
    }

    public String serializeAttributeValue(Object value) {
        if (value == null) {
            return null;
        }
        return this.getValueAsTypeInstance(value).stream().map(x -> "(" + x.getContext() + ";" + x.getAlternative() + ")").reduce("", (a, b) -> a + (a.isEmpty() ? "" : ">") + b);
    }

    public Object deserializeAttributeValue(String string) {
        String[] split = string.split(">");
        Ranking ranking = new Ranking();
        Arrays.stream(split).map(x -> x.substring(1, x.length() - 1)).map(x -> new Dyad(this.parseVector(x.split(";")[0]), this.parseVector(x.split(",")[1]))).forEach(ranking::add);
        return ranking;
    }

    private IVector parseVector(String vectorString) {
        String[] split = vectorString.substring(1, vectorString.length() - 1).split(",");
        return new DenseDoubleVector(Arrays.stream(split).mapToDouble(Double::parseDouble).toArray());
    }
}

