/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.schema.attribute;

import ai.libs.jaicore.ml.core.dataset.schema.attribute.AAttribute;
import ai.libs.jaicore.ml.core.dataset.schema.attribute.IntBasedCategoricalAttributeValue;
import java.util.List;
import org.api4.java.ai.ml.core.dataset.schema.attribute.ICategoricalAttribute;
import org.api4.java.ai.ml.core.dataset.schema.attribute.ICategoricalAttributeValue;

public class IntBasedCategoricalAttribute
extends AAttribute
implements ICategoricalAttribute {
    private static final long serialVersionUID = 3727153881173459843L;
    private final List<String> domain;
    private final int numCategories;

    public IntBasedCategoricalAttribute(String name, List<String> domain) {
        super(name);
        this.domain = domain;
        this.numCategories = domain.size();
    }

    public String getStringDescriptionOfDomain() {
        return this.domain.toString();
    }

    public List<String> getLabels() {
        return this.domain;
    }

    public boolean isBinary() {
        return this.getLabels().size() == 2;
    }

    public boolean isValidValue(Object attributeValue) {
        if (attributeValue == null) {
            return true;
        }
        Integer value = null;
        if (attributeValue instanceof ICategoricalAttributeValue) {
            value = ((ICategoricalAttributeValue)attributeValue).getValue();
        } else if (attributeValue instanceof Integer) {
            value = (Integer)attributeValue;
        } else if (attributeValue instanceof Double) {
            value = (int)((Double)attributeValue).doubleValue();
        } else if (this.domain.contains(attributeValue)) {
            value = this.domain.indexOf(attributeValue);
        }
        if (value == null) {
            return false;
        }
        return value < this.domain.size();
    }

    public double encodeValue(Object attributeValue) {
        if (!this.isValidValue(attributeValue)) {
            throw new IllegalArgumentException("No valid attribute value.");
        }
        return this.domain.indexOf(this.getLabelOfAttributeValue(attributeValue));
    }

    public String decodeValue(double encodedAttributeValue) {
        return this.domain.get((int)encodedAttributeValue);
    }

    private String getLabelOfAttributeValue(Object object) {
        if (object instanceof ICategoricalAttributeValue) {
            return this.domain.get(((ICategoricalAttributeValue)object).getValue());
        }
        if (object instanceof String) {
            return (String)object;
        }
        throw new IllegalArgumentException("No valid attribute value");
    }

    public ICategoricalAttributeValue getAsAttributeValue(Object object) {
        if (object == null) {
            return null;
        }
        if (this.isValidValue(object)) {
            int cObject;
            if (object instanceof Integer) {
                cObject = (Integer)object;
            } else if (this.domain.contains(object)) {
                cObject = this.domain.indexOf(object);
            } else if (object instanceof ICategoricalAttributeValue) {
                cObject = ((ICategoricalAttributeValue)object).getValue();
            } else {
                throw new IllegalStateException("Object should be parseable after the test.");
            }
            return new IntBasedCategoricalAttributeValue(this, cObject);
        }
        throw new IllegalArgumentException(object + " is an invalid value for categorical attribute with domain " + this.getStringDescriptionOfDomain());
    }

    public ICategoricalAttributeValue getAsAttributeValue(double encodedAttributeValue) {
        return this.getAsAttributeValue(this.decodeValue(encodedAttributeValue));
    }

    public String getNameOfCategory(int categoryId) {
        return this.domain.get(categoryId);
    }

    public int getIdOfLabel(String label) {
        return this.domain.indexOf(label);
    }

    public double toDouble(Object value) {
        if (!(value instanceof Integer)) {
            throw new IllegalArgumentException();
        }
        return this.domain.indexOf(value);
    }

    public String serializeAttributeValue(Object value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Integer)) {
            throw new IllegalArgumentException("Can only serialize the integer representation of a category.");
        }
        if ((Integer)value < 0) {
            return null;
        }
        return this.domain.get((Integer)value);
    }

    public Integer deserializeAttributeValue(String string) {
        if (!this.domain.contains(string)) {
            return null;
        }
        String trimmedString = string.trim();
        if (string.startsWith("'") && string.endsWith("'") || string.startsWith("\"") && string.endsWith("\"")) {
            trimmedString = trimmedString.substring(1, trimmedString.length() - 1);
        }
        return this.domain.indexOf(trimmedString);
    }

    public int getNumberOfCategories() {
        return this.numCategories;
    }

    public String getLabelOfCategory(Number categoryId) {
        return this.domain.get((Integer)categoryId);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + this.numCategories;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntBasedCategoricalAttribute other = (IntBasedCategoricalAttribute)obj;
        if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
            return false;
        }
        return this.numCategories == other.numCategories;
    }
}

