/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.serialization;

import ai.libs.jaicore.db.IDatabaseAdapter;
import ai.libs.jaicore.ml.core.dataset.Dataset;
import ai.libs.jaicore.ml.core.dataset.DenseInstance;
import ai.libs.jaicore.ml.core.dataset.schema.InstanceSchema;
import ai.libs.jaicore.ml.core.dataset.schema.LabeledInstanceSchema;
import ai.libs.jaicore.ml.core.dataset.schema.attribute.IntBasedCategoricalAttribute;
import ai.libs.jaicore.ml.core.dataset.schema.attribute.NumericAttribute;
import ai.libs.jaicore.ml.core.dataset.serialization.ISQLDatasetMapper;
import java.sql.SQLException;
import java.sql.Time;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.api4.java.ai.ml.core.dataset.IDataset;
import org.api4.java.ai.ml.core.dataset.schema.IInstanceSchema;
import org.api4.java.ai.ml.core.dataset.schema.ILabeledInstanceSchema;
import org.api4.java.ai.ml.core.dataset.schema.attribute.IAttribute;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledDataset;
import org.api4.java.datastructure.kvstore.IKVStore;

public class MySQLDatasetMapper
implements ISQLDatasetMapper {
    private final IDatabaseAdapter adapter;

    public MySQLDatasetMapper(IDatabaseAdapter adapter) {
        this.adapter = adapter;
    }

    private String getTableSelectQuery(String tableName) {
        return "SELECT * FROM `" + tableName + "`";
    }

    @Override
    public IDataset<?> readDatasetFromTable(String tableName) throws SQLException {
        return this.readDatasetFromQuery(this.getTableSelectQuery(tableName));
    }

    @Override
    public ILabeledDataset<?> readDatasetFromTable(String tableName, String labelField) throws SQLException {
        return this.readDatasetFromQuery(this.getTableSelectQuery(tableName), labelField);
    }

    @Override
    public IDataset<?> readDatasetFromQuery(String sqlQuery) throws SQLException {
        throw new UnsupportedOperationException("Can currently only handle labeled data");
    }

    @Override
    public ILabeledDataset<?> readDatasetFromQuery(String sqlQuery, String labelField) throws SQLException {
        List relation = this.adapter.getResultsOfQuery(sqlQuery);
        ILabeledInstanceSchema schema = this.getInstanceSchemaFromResultList(relation, labelField);
        Dataset ds = new Dataset(schema);
        for (IKVStore row : relation) {
            ArrayList<Object> attributeValues = new ArrayList<Object>();
            for (IAttribute attribute : schema.getAttributeList()) {
                if (attribute.getName().equals(labelField)) continue;
                Object receivedVal = row.get((Object)attribute.getName());
                Object convertedVal = receivedVal == null ? null : attribute.getAsAttributeValue(receivedVal).getValue();
                attributeValues.add(convertedVal);
            }
            Object labelAttribute = schema.getLabelAttribute().getAsAttributeValue(row.get((Object)labelField)).getValue();
            ds.add(new DenseInstance(attributeValues, labelAttribute));
        }
        return ds;
    }

    @Override
    public void writeDatasetToDatabase(IDataset<?> dataset, String tableName) {
        throw new UnsupportedOperationException("Currently, only read access to the database is supported.");
    }

    @Override
    public IInstanceSchema getInstanceSchemaOfTable(String tableName) throws SQLException {
        return this.getInstanceSchemaForQuery(this.getTableSelectQuery(tableName));
    }

    @Override
    public ILabeledInstanceSchema getInstanceSchemaOfTable(String tableName, String labelField) throws SQLException {
        return this.getInstanceSchemaForQuery(this.getTableSelectQuery(tableName), labelField);
    }

    @Override
    public IInstanceSchema getInstanceSchemaForQuery(String sqlQuery) throws SQLException {
        return this.getInstanceSchemaFromResultList(this.adapter.getResultsOfQuery(sqlQuery));
    }

    @Override
    public ILabeledInstanceSchema getInstanceSchemaForQuery(String sqlQuery, String labelField) throws SQLException {
        return this.convertInstanceSchemaIntoLabeledInstanceSchema(this.getInstanceSchemaForQuery(sqlQuery), labelField);
    }

    public IInstanceSchema getInstanceSchemaFromResultList(List<IKVStore> data) {
        IKVStore firstRow = data.get(0);
        ArrayList<IAttribute> attributeList = new ArrayList<IAttribute>(firstRow.size());
        for (Map.Entry serializedAttribute : firstRow.entrySet()) {
            Object val = serializedAttribute.getValue();
            String key = (String)serializedAttribute.getKey();
            if (val == null) continue;
            if (val instanceof Number || val instanceof String && NumberUtils.isCreatable((String)((String)val))) {
                attributeList.add((IAttribute)new NumericAttribute(key));
                continue;
            }
            if (val instanceof String || val instanceof Time) {
                Set availableValues = data.stream().map(r -> r.get((Object)key)).filter(Objects::nonNull).collect(Collectors.toSet());
                attributeList.add((IAttribute)new IntBasedCategoricalAttribute(key, availableValues.stream().map(Object::toString).collect(Collectors.toList())));
                continue;
            }
            throw new UnsupportedOperationException("Cannot recognize type of attribute " + key + " with value " + val + " of type " + val.getClass().getName());
        }
        return new InstanceSchema("SQL-mapped data", attributeList);
    }

    public ILabeledInstanceSchema convertInstanceSchemaIntoLabeledInstanceSchema(IInstanceSchema schema, String labelField) {
        ArrayList<IAttribute> allAttributes = new ArrayList<IAttribute>(schema.getAttributeList());
        IAttribute targetAttribute = allAttributes.stream().filter(a -> a.getName().equals(labelField)).findAny().get();
        allAttributes.remove(targetAttribute);
        return new LabeledInstanceSchema(schema.getRelationName(), allAttributes, targetAttribute);
    }

    public ILabeledInstanceSchema getInstanceSchemaFromResultList(List<IKVStore> data, String labelField) {
        return this.convertInstanceSchemaIntoLabeledInstanceSchema(this.getInstanceSchemaFromResultList(data), labelField);
    }
}

