/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.splitter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.api4.java.ai.ml.core.dataset.IDataset;
import org.api4.java.ai.ml.core.evaluation.execution.IDatasetSplitSet;

public class DatasetSplitSet<D extends IDataset<?>>
implements IDatasetSplitSet<D> {
    private final List<List<D>> splits = new ArrayList<List<D>>();

    public DatasetSplitSet() {
    }

    public DatasetSplitSet(IDatasetSplitSet<D> set) {
        int n = set.getNumberOfSplits();
        if (n == 0) {
            throw new IllegalArgumentException("Cannot create a split set with no folds.");
        }
        for (int i = 0; i < n; ++i) {
            this.splits.add(new ArrayList(set.getFolds(i)));
        }
    }

    public DatasetSplitSet(List<List<D>> splits) {
        this.splits.addAll(splits);
    }

    public void addSplit(List<D> split) {
        this.splits.add(split);
    }

    public int getNumberOfSplits() {
        return this.splits.size();
    }

    public int getNumberOfFoldsPerSplit() {
        return this.splits.get(0).size();
    }

    public int getNumberOfFoldsForSplit(int pos) {
        return this.splits.get(pos).size();
    }

    public List<D> getFolds(int splitId) {
        return Collections.unmodifiableList(this.splits.get(splitId));
    }
}

