/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.evaluation;

import ai.libs.jaicore.ml.classification.loss.dataset.EAggregatedClassifierMetric;
import ai.libs.jaicore.ml.core.evaluation.evaluator.MonteCarloCrossValidationEvaluator;
import ai.libs.jaicore.ml.core.evaluation.evaluator.SupervisedLearnerExecutor;
import java.util.Random;
import org.api4.java.ai.ml.classification.singlelabel.evaluation.ISingleLabelClassification;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledDataset;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledInstance;
import org.api4.java.ai.ml.core.evaluation.ISupervisedLearnerEvaluator;
import org.api4.java.ai.ml.core.evaluation.execution.ILearnerRunReport;
import org.api4.java.ai.ml.core.evaluation.execution.LearnerExecutionFailedException;
import org.api4.java.ai.ml.core.evaluation.supervised.loss.IDeterministicPredictionPerformanceMeasure;
import org.api4.java.ai.ml.core.learner.ISupervisedLearner;
import org.api4.java.common.attributedobjects.ObjectEvaluationFailedException;

public class MLEvaluationUtil {
    private MLEvaluationUtil() {
    }

    public static double evaluate(ISupervisedLearner<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>> learner, ISupervisedLearnerEvaluator<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>> evaluator) throws ObjectEvaluationFailedException, InterruptedException {
        return (Double)evaluator.evaluate(learner);
    }

    public static double getLossForTrainedClassifier(ISupervisedLearner<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>> learner, ILabeledDataset<? extends ILabeledInstance> testData, IDeterministicPredictionPerformanceMeasure<Integer, ISingleLabelClassification> measure) throws LearnerExecutionFailedException {
        SupervisedLearnerExecutor executor = new SupervisedLearnerExecutor();
        ILearnerRunReport report = executor.execute(learner, testData);
        return measure.loss(report.getPredictionDiffList().getCastedView(Integer.class, ISingleLabelClassification.class));
    }

    public static double mccv(ISupervisedLearner<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>> learner, ILabeledDataset<? extends ILabeledInstance> data, int repeats, double trainFoldSize, long seed, EAggregatedClassifierMetric metric) throws ObjectEvaluationFailedException, InterruptedException {
        return MLEvaluationUtil.evaluate(learner, (ISupervisedLearnerEvaluator<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>>)new MonteCarloCrossValidationEvaluator(false, data, repeats, trainFoldSize, new Random(seed), metric));
    }

    public static double mccv(ISupervisedLearner<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>> learner, ILabeledDataset<? extends ILabeledInstance> data, int repeats, double trainFoldSize, long seed) throws ObjectEvaluationFailedException, InterruptedException {
        return MLEvaluationUtil.mccv(learner, data, repeats, trainFoldSize, seed, EAggregatedClassifierMetric.MEAN_ERRORRATE);
    }
}

