/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.evaluation.evaluator;

import ai.libs.jaicore.ml.core.filter.sampling.inmemory.ASamplingAlgorithm;
import ai.libs.jaicore.ml.core.filter.sampling.inmemory.factories.interfaces.ISamplingAlgorithmFactory;
import ai.libs.jaicore.ml.functionprediction.learner.learningcurveextrapolation.ConfigurationLearningCurveExtrapolator;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledDataset;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledInstance;
import org.api4.java.ai.ml.core.evaluation.ISupervisedLearnerEvaluator;
import org.api4.java.ai.ml.core.evaluation.learningcurve.ILearningCurve;
import org.api4.java.ai.ml.core.learner.ISupervisedLearner;
import org.api4.java.common.attributedobjects.ObjectEvaluationFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationLearningCurveExtrapolationEvaluator
implements ISupervisedLearnerEvaluator<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>> {
    private Logger logger = LoggerFactory.getLogger(ConfigurationLearningCurveExtrapolationEvaluator.class);
    private int[] anchorpoints;
    private ISamplingAlgorithmFactory<ILabeledDataset<?>, ASamplingAlgorithm<ILabeledDataset<?>>> samplingAlgorithmFactory;
    private ILabeledDataset<?> dataset;
    private double trainSplitForAnchorpointsMeasurement;
    private long seed;
    private String identifier;
    private double[] configurations;
    private int fullDatasetSize = -1;

    public ConfigurationLearningCurveExtrapolationEvaluator(int[] anchorpoints, ISamplingAlgorithmFactory<ILabeledDataset<?>, ASamplingAlgorithm<ILabeledDataset<?>>> samplingAlgorithmFactory, ILabeledDataset<?> dataset, double trainSplitForAnchorpointsMeasurement, long seed, String identifier, double[] configurations) {
        this.anchorpoints = anchorpoints;
        this.samplingAlgorithmFactory = samplingAlgorithmFactory;
        this.dataset = dataset;
        this.trainSplitForAnchorpointsMeasurement = trainSplitForAnchorpointsMeasurement;
        this.seed = seed;
        this.identifier = identifier;
        this.configurations = configurations;
    }

    public void setFullDatasetSize(int fullDatasetSize) {
        this.fullDatasetSize = fullDatasetSize;
    }

    public Double evaluate(ISupervisedLearner<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>> classifier) throws InterruptedException, ObjectEvaluationFailedException {
        try {
            ConfigurationLearningCurveExtrapolator extrapolator = new ConfigurationLearningCurveExtrapolator(classifier, this.dataset, this.trainSplitForAnchorpointsMeasurement, this.anchorpoints, this.samplingAlgorithmFactory, this.seed, this.identifier, this.configurations);
            ILearningCurve learningCurve = extrapolator.extrapolateLearningCurve();
            int evaluationPoint = this.dataset.size();
            if (this.fullDatasetSize != -1) {
                evaluationPoint = this.fullDatasetSize;
            }
            return learningCurve.getCurveValue((double)evaluationPoint) * 100.0;
        }
        catch (Exception e) {
            this.logger.warn("Evaluation of classifier failed due Exception {} with message {}. Returning null.", (Object)e.getClass().getName(), (Object)e.getMessage());
            return null;
        }
    }
}

