/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.evaluation.evaluator;

import ai.libs.jaicore.ml.core.evaluation.evaluator.FixedSplitClassifierEvaluator;
import ai.libs.jaicore.ml.core.filter.sampling.inmemory.ASamplingAlgorithm;
import ai.libs.jaicore.ml.core.filter.sampling.inmemory.factories.interfaces.ISamplingAlgorithmFactory;
import ai.libs.jaicore.ml.functionprediction.learner.learningcurveextrapolation.InvalidAnchorPointsException;
import ai.libs.jaicore.ml.functionprediction.learner.learningcurveextrapolation.LearningCurveExtrapolationMethod;
import ai.libs.jaicore.ml.functionprediction.learner.learningcurveextrapolation.LearningCurveExtrapolator;
import java.util.Random;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledDataset;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledInstance;
import org.api4.java.ai.ml.core.evaluation.ISupervisedLearnerEvaluator;
import org.api4.java.ai.ml.core.evaluation.learningcurve.IAnalyticalLearningCurve;
import org.api4.java.ai.ml.core.evaluation.supervised.loss.IDeterministicPredictionPerformanceMeasure;
import org.api4.java.ai.ml.core.exception.DatasetCreationException;
import org.api4.java.ai.ml.core.learner.ISupervisedLearner;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;
import org.api4.java.common.attributedobjects.ObjectEvaluationFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtrapolatedSaturationPointEvaluator
implements ISupervisedLearnerEvaluator<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>> {
    private static final Logger logger = LoggerFactory.getLogger(ExtrapolatedSaturationPointEvaluator.class);
    private static final double DEFAULT_EPSILON = 0.1;
    private int[] anchorpoints;
    private ISamplingAlgorithmFactory<ILabeledDataset<?>, ? extends ASamplingAlgorithm<ILabeledDataset<?>>> samplingAlgorithmFactory;
    private ILabeledDataset<?> train;
    private double trainSplitForAnchorpointsMeasurement;
    private LearningCurveExtrapolationMethod extrapolationMethod;
    private long seed;
    private double epsilon;
    private ILabeledDataset<?> test;
    private IDeterministicPredictionPerformanceMeasure<?, ?> measure;

    public ExtrapolatedSaturationPointEvaluator(int[] anchorpoints, ISamplingAlgorithmFactory<ILabeledDataset<?>, ? extends ASamplingAlgorithm<ILabeledDataset<?>>> samplingAlgorithmFactory, ILabeledDataset<?> train, double trainSplitForAnchorpointsMeasurement, LearningCurveExtrapolationMethod extrapolationMethod, long seed, ILabeledDataset<?> test, IDeterministicPredictionPerformanceMeasure<?, ?> measure) {
        this.anchorpoints = anchorpoints;
        this.samplingAlgorithmFactory = samplingAlgorithmFactory;
        this.train = train;
        this.trainSplitForAnchorpointsMeasurement = trainSplitForAnchorpointsMeasurement;
        this.extrapolationMethod = extrapolationMethod;
        this.seed = seed;
        this.epsilon = 0.1;
        this.test = test;
        this.measure = measure;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public Double evaluate(ISupervisedLearner<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>> learner) throws InterruptedException, ObjectEvaluationFailedException {
        try {
            LearningCurveExtrapolator extrapolator = new LearningCurveExtrapolator(this.extrapolationMethod, learner, this.train, this.trainSplitForAnchorpointsMeasurement, this.anchorpoints, this.samplingAlgorithmFactory, this.seed);
            IAnalyticalLearningCurve learningCurve = (IAnalyticalLearningCurve)extrapolator.extrapolateLearningCurve();
            int optimalSampleSize = Math.min(this.train.size(), (int)learningCurve.getSaturationPoint(this.epsilon));
            ASamplingAlgorithm<ILabeledDataset<?>> samplingAlgorithm = this.samplingAlgorithmFactory.getAlgorithm(optimalSampleSize, this.train, new Random(this.seed));
            ILabeledDataset<?> saturationPointTrainSet = samplingAlgorithm.call();
            FixedSplitClassifierEvaluator evaluator = new FixedSplitClassifierEvaluator(saturationPointTrainSet, this.test, this.measure);
            return evaluator.evaluate(learner);
        }
        catch (InvalidAnchorPointsException | DatasetCreationException | AlgorithmException | AlgorithmExecutionCanceledException | AlgorithmTimeoutedException e) {
            logger.warn("Evaluation of classifier failed due Exception {} with message {}. Returning null.", (Object)e.getClass().getName(), (Object)e.getMessage());
            return null;
        }
    }
}

