/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.evaluation.evaluator;

import ai.libs.jaicore.basic.sets.ListView;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.api4.java.ai.ml.core.evaluation.IPredictionAndGroundTruthTable;

public class PredictionDiff<E, A>
implements IPredictionAndGroundTruthTable<E, A> {
    private final Class<?> expectedClass;
    private final Class<?> predictionClass;
    private final List<E> groundTruths = new ArrayList();
    private final List<A> predictions = new ArrayList<A>();

    public PredictionDiff() {
        Type genericSuperClass = this.getClass().getGenericSuperclass();
        this.expectedClass = genericSuperClass instanceof ParameterizedType ? ((ParameterizedType)genericSuperClass).getActualTypeArguments()[0].getClass() : Object.class;
        this.predictionClass = genericSuperClass instanceof ParameterizedType ? ((ParameterizedType)genericSuperClass).getActualTypeArguments()[1].getClass() : Object.class;
    }

    public PredictionDiff(List<? extends E> groundTruths, List<? extends A> predictions) {
        this();
        if (predictions.size() != groundTruths.size()) {
            throw new IllegalArgumentException("Predictions and ground truths must have the same length!");
        }
        this.predictions.addAll(predictions);
        this.groundTruths.addAll(groundTruths);
    }

    public void addPair(E groundTruth, A prediction) {
        this.groundTruths.add(groundTruth);
        this.predictions.add(prediction);
    }

    public <E1, A1> PredictionDiff<E1, A1> getCastedView(Class<E1> expectedClass, Class<A1> actualClass) {
        return new PredictionDiff<E, A>(new ListView(this.groundTruths), new ListView(this.predictions));
    }

    public int size() {
        return this.predictions.size();
    }

    public A getPrediction(int instance) {
        return this.predictions.get(instance);
    }

    public E getGroundTruth(int instance) {
        return this.groundTruths.get(instance);
    }

    public List<A> getPredictionsAsList() {
        return Collections.unmodifiableList(this.predictions);
    }

    public <T> List<T> getPredictionsAsList(Class<T> clazz) {
        return Collections.unmodifiableList(new ListView(this.predictions, clazz));
    }

    public A[] getPredictionsAsArray() {
        return this.predictions.toArray((Object[])Array.newInstance(this.predictionClass, this.predictions.size()));
    }

    public List<E> getGroundTruthAsList() {
        return Collections.unmodifiableList(this.groundTruths);
    }

    public <T> List<T> getGroundTruthAsList(Class<T> clazz) {
        return Collections.unmodifiableList(new ListView(this.groundTruths, clazz));
    }

    public E[] getGroundTruthAsArray() {
        return this.groundTruths.toArray((Object[])Array.newInstance(this.expectedClass, this.groundTruths.size()));
    }
}

