/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.evaluation.evaluator.factory;

import ai.libs.jaicore.ml.core.evaluation.AveragingPredictionPerformanceMeasure;
import ai.libs.jaicore.ml.core.evaluation.evaluator.MonteCarloCrossValidationEvaluator;
import ai.libs.jaicore.ml.core.evaluation.evaluator.factory.AMonteCarloCrossValidationBasedEvaluatorFactory;
import java.util.Objects;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledDataset;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledInstance;

public class MonteCarloCrossValidationEvaluatorFactory
extends AMonteCarloCrossValidationBasedEvaluatorFactory<MonteCarloCrossValidationEvaluatorFactory> {
    public MonteCarloCrossValidationEvaluator getLearnerEvaluator() {
        if (this.getTrainFoldSize() <= 0.0 || this.getTrainFoldSize() >= 1.0) {
            throw new IllegalStateException("Train fold size is configured to " + this.getTrainFoldSize() + " but must be strictly greater than 0 and strictly smaller than 1.");
        }
        Objects.requireNonNull(this.random, "No random source has been defined for the MCCV.");
        Objects.requireNonNull(this.data, "No data has been set for the MCCV.");
        Objects.requireNonNull(this.metric, "No metric has been set for the MCCV.");
        if (this.numMCIterations <= 0) {
            throw new IllegalStateException("Cannot create MCCV evaluator due to invalid number of repeats " + this.getNumMCIterations() + ". Set number of repeats to a positive value!");
        }
        AveragingPredictionPerformanceMeasure aggMeasure = new AveragingPredictionPerformanceMeasure(this.metric);
        return new MonteCarloCrossValidationEvaluator(this.getCacheSplitSets(), (ILabeledDataset<? extends ILabeledInstance>)this.data, this.getNumMCIterations(), this.getTrainFoldSize(), this.random, aggMeasure);
    }

    @Override
    public MonteCarloCrossValidationEvaluatorFactory getSelf() {
        return this;
    }
}

