/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.evaluation.splitsetgenerator;

import org.api4.java.ai.ml.core.dataset.IDataset;
import org.api4.java.ai.ml.core.dataset.splitter.SplitFailedException;
import org.api4.java.ai.ml.core.evaluation.execution.IDatasetSplitSet;
import org.api4.java.ai.ml.core.evaluation.execution.IDatasetSplitSetGenerator;
import org.api4.java.ai.ml.core.evaluation.execution.IFixedDatasetSplitSetGenerator;
import org.api4.java.common.control.ILoggingCustomizable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedDataSplitSetGenerator<D extends IDataset<?>>
implements IFixedDatasetSplitSetGenerator<D>,
ILoggingCustomizable {
    private final D data;
    private final IDatasetSplitSetGenerator<D> generator;
    private Logger logger = LoggerFactory.getLogger(FixedDataSplitSetGenerator.class);

    public FixedDataSplitSetGenerator(D data, IDatasetSplitSetGenerator<D> generator) {
        this.data = data;
        this.generator = generator;
    }

    public int getNumSplitsPerSet() {
        return this.generator.getNumFoldsPerSplit();
    }

    public int getNumFoldsPerSplit() {
        return this.generator.getNumFoldsPerSplit();
    }

    public IDatasetSplitSet<D> nextSplitSet() throws InterruptedException, SplitFailedException {
        return this.generator.nextSplitSet(this.data);
    }

    public D getDataset() {
        return this.data;
    }

    public String toString() {
        return "FixedDataSplitSetGenerator [data=" + this.data + ", generator=" + this.generator + "]";
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
        if (this.generator instanceof ILoggingCustomizable) {
            ((ILoggingCustomizable)this.generator).setLoggerName(name + ".splitgen");
            this.logger.info("Setting logger of base split generator {} to {}.splitgen", (Object)this.generator.getClass().getName(), (Object)name);
        } else {
            this.logger.info("Base split generator {} is not configurable for logging, so not configuring it.", (Object)this.generator.getClass().getName());
        }
    }
}

