/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.filter.sampling.infiles;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class ArffUtilities {
    private static final String DATA_TAG = "@data";

    private ArffUtilities() {
    }

    public static String extractArffHeader(File file) throws IOException {
        StringBuilder header = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String line;
            boolean finishedHeader = false;
            while ((line = bufferedReader.readLine()) != null && !finishedHeader) {
                if (line.trim().equals("") || line.trim().charAt(0) == '%') continue;
                header.append(line.trim());
                header.append("\n");
                if (!line.trim().equals(DATA_TAG)) continue;
                finishedHeader = true;
            }
        }
        return header.toString();
    }

    public static int countDatasetEntries(File file, boolean hasHeader) throws IOException {
        int result = 0;
        boolean startCounting = !hasHeader;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.trim().equals("") || line.trim().charAt(0) == '%') continue;
                if (startCounting) {
                    ++result;
                    continue;
                }
                if (!line.trim().equals(DATA_TAG)) continue;
                startCounting = true;
            }
        }
        return result;
    }

    public static void skipWithReaderToDatapoints(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            if (!line.trim().equals(DATA_TAG)) continue;
            return;
        }
    }
}

