/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.filter.sampling.infiles;

import ai.libs.jaicore.ml.core.filter.sampling.SampleElementAddedEvent;
import ai.libs.jaicore.ml.core.filter.sampling.infiles.AFileSamplingAlgorithm;
import ai.libs.jaicore.ml.core.filter.sampling.infiles.ArffUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Random;
import org.api4.java.algorithm.IAlgorithm;
import org.api4.java.algorithm.events.IAlgorithmEvent;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;

public class ReservoirSampling
extends AFileSamplingAlgorithm {
    private Random random;
    private BufferedReader reader;
    private int datapointAmount;
    private int streamedDatapoints;
    private String[] sampledDatapoints;

    public ReservoirSampling(Random random, File input) {
        super(input);
        this.random = random;
    }

    public IAlgorithmEvent nextWithException() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmException {
        switch (this.getState()) {
            case CREATED: {
                try {
                    this.datapointAmount = ArffUtilities.countDatasetEntries((File)this.getInput(), true);
                    this.streamedDatapoints = 0;
                    this.sampledDatapoints = new String[this.sampleSize.intValue()];
                    this.reader = new BufferedReader(new FileReader((File)this.getInput()));
                    ArffUtilities.skipWithReaderToDatapoints(this.reader);
                    return this.activate();
                }
                catch (IOException e) {
                    throw new AlgorithmException("Was not able to count the datapoints.", (Throwable)e);
                }
            }
            case ACTIVE: {
                if (this.streamedDatapoints < this.datapointAmount) {
                    try {
                        String datapoint = this.reader.readLine();
                        if (datapoint != null && datapoint.trim().length() > 0 && datapoint.trim().charAt(0) != '%') {
                            if (this.streamedDatapoints < this.sampleSize) {
                                this.sampledDatapoints[this.streamedDatapoints] = datapoint.trim();
                            } else {
                                int j = this.random.nextInt(this.streamedDatapoints);
                                if (j < this.sampleSize) {
                                    this.sampledDatapoints[j] = datapoint.trim();
                                }
                            }
                        }
                        ++this.streamedDatapoints;
                        return new SampleElementAddedEvent((IAlgorithm<?, ?>)this);
                    }
                    catch (IOException e) {
                        throw new AlgorithmException("Was not able to read datapoint line from input file", (Throwable)e);
                    }
                }
                try {
                    this.reader.close();
                    for (int i = 0; i < this.sampledDatapoints.length; ++i) {
                        this.outputFileWriter.write(this.sampledDatapoints[i] + "\n");
                    }
                    return this.terminate();
                }
                catch (IOException e) {
                    throw new AlgorithmException("Was not able to write sampled datapoints into output files.", (Throwable)e);
                }
            }
            case INACTIVE: {
                if (this.streamedDatapoints < this.datapointAmount) {
                    throw new AlgorithmException("Expected sample size was not reached before termination");
                }
                return this.terminate();
            }
        }
        throw new IllegalStateException("Unknown algorithm state " + this.getState());
    }

    @Override
    protected void cleanUp() {
    }
}

